/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import sonar.core.inventory.StoredItemStack;
import sonar.core.utils.helpers.FontHelper;
import sonar.logistics.api.Info;

public class StoredStackInfo
extends Info {
    public StoredItemStack stack;
    public String rend = "ITEMREND";

    public static StoredStackInfo createInfo(StoredItemStack stack) {
        StoredStackInfo info = new StoredStackInfo();
        info.stack = stack;
        return info;
    }

    @Override
    public String getName() {
        return "StoredStack";
    }

    @Override
    public byte getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return this.rend;
    }

    @Override
    public String getSubCategory() {
        return this.stack != null ? this.stack.item.func_82833_r() : this.rend;
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public String getData() {
        return this.stack != null ? String.valueOf(this.stack.stored) : String.valueOf(0);
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.stack = StoredItemStack.readFromBuf((ByteBuf)buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        StoredItemStack.writeToBuf((ByteBuf)buf, (StoredItemStack)this.stack);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stack = StoredItemStack.readFromNBT((NBTTagCompound)tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        StoredItemStack.writeToNBT((NBTTagCompound)tag, (StoredItemStack)this.stack);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, float scale) {
        if (this.stack != null && this.stack.item != null) {
            GL11.glTranslatef((float)(minX + (maxX - minX) / 2.0f), (float)(minY + maxY / 2.0f), (float)0.01f);
            FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
            this.stack.item.field_77994_a = 1;
            int br = 0x1000100;
            int var11 = 256;
            int var12 = 256;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.8f, (float)204.8f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)32826);
            GL11.glEnable((int)2884);
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            double sizing = Math.round(Math.min(maxX - minX, maxY - minY));
            double itemScale = sizing >= 2.0 ? 2.5 + sizing - 1.0 : (scale >= 120.0f ? (double)0.8f : (double)1.4f);
            GL11.glTranslatef((float)0.0f, (float)((float)(scale >= 120.0f ? (double)0.07f : (double)0.13f + (sizing - 1.0) * 0.15)), (float)(zOffset - 0.01f));
            GL11.glScaled((double)itemScale, (double)itemScale, (double)itemScale);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.25f);
            RenderHelper.func_74520_c();
            sonar.core.utils.helpers.RenderHelper.doRenderItem((ItemStack)this.stack.item, (World)tile.func_145831_w(), (boolean)false);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.242f);
            GL11.glScalef((float)0.025f, (float)0.025f, (float)0.025f);
            String s1 = FontHelper.formatStackSize((long)this.stack.stored);
            float scaleFactor = 0.5f;
            float inverseScaleFactor = 2.0f;
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            int X = (int)((7.0f - (float)rend.func_78256_a(s1) * 0.5f) * 2.0f);
            int Y = -1;
            GL11.glDisable((int)2896);
            rend.func_78276_b(s1, X, -1, 0xFFFFFF);
        }
    }

    @Override
    public boolean isEqualType(Info info) {
        if (info instanceof StoredStackInfo) {
            StoredStackInfo stackInfo = (StoredStackInfo)info;
            if (stackInfo.stack.stored != this.stack.stored) {
                return false;
            }
            return stackInfo.stack.equalStack(this.stack.item);
        }
        return false;
    }

    @Override
    public void emptyData() {
    }

    public StoredStackInfo newInfo() {
        return new StoredStackInfo();
    }
}

