/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;
import sonar.logistics.api.Info;
import sonar.logistics.client.renderers.RenderHandlers;

public class ProgressInfo
extends Info {
    private static final ResourceLocation progress = new ResourceLocation(RenderHandlers.modelFolder + "progressBar.png");
    public String data;
    public long stored;
    public long max;
    public int fluidID = -1;
    public String rend = "Progress";

    public ProgressInfo() {
    }

    public ProgressInfo(long stored, long max, String data) {
        this.stored = stored;
        this.max = max;
        this.data = data;
    }

    public ProgressInfo(long stored, long max, String data, int fluidID) {
        this.stored = stored;
        this.max = max;
        this.data = data;
        this.fluidID = fluidID;
    }

    @Override
    public String getName() {
        return "ProgressBar";
    }

    @Override
    public byte getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return this.rend;
    }

    @Override
    public String getSubCategory() {
        return this.rend;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.stored = buf.readLong();
        this.max = buf.readLong();
        this.fluidID = buf.readInt();
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeLong(this.stored);
        buf.writeLong(this.max);
        buf.writeInt(this.fluidID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stored = tag.func_74763_f("stored");
        this.max = tag.func_74763_f("max");
        this.fluidID = tag.func_74762_e("fluidID");
        this.data = tag.func_74779_i("data");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74772_a("stored", this.stored);
        tag.func_74772_a("max", this.max);
        tag.func_74768_a("fluidID", this.fluidID);
        tag.func_74778_a("data", this.data);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, float scale) {
        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslated((double)0.0, (double)0.0, (double)zOffset);
        float width = (float)this.stored * (maxX - minX) / (float)this.max;
        float height = (float)this.stored * (maxY - minY) / (float)this.max;
        boolean renderNormal = true;
        if (this.fluidID != -1 && FluidRegistry.getFluid((int)this.fluidID) != null) {
            IIcon icon = FluidRegistry.getFluid((int)this.fluidID).getIcon();
            renderNormal = false;
            if (icon != null) {
                renderNormal = false;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                tess.func_78382_b();
                double divide = Math.max(0.5 + (double)(maxX - minX), 0.5 + (double)(maxY - minY));
                double widthnew = (double)icon.func_94209_e() + (double)(width * (icon.func_94212_f() - icon.func_94209_e())) / divide;
                double heightnew = (double)icon.func_94206_g() + (double)(maxY * (icon.func_94210_h() - icon.func_94206_g())) / divide;
                tess.func_78374_a((double)(minX + 0.0f), (double)(minY + maxY), 0.0, (double)icon.func_94209_e(), heightnew);
                tess.func_78374_a((double)(minX + width), (double)(minY + maxY), 0.0, widthnew, heightnew);
                tess.func_78374_a((double)(minX + width), (double)(minY + 0.0f), 0.0, widthnew, (double)icon.func_94206_g());
                tess.func_78374_a((double)(minX + 0.0f), (double)(minY + 0.0f), 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
                tess.func_78381_a();
            }
        }
        if (renderNormal) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(progress);
            tess.func_78382_b();
            double widthnew = 0.0f + width * 2.0f;
            double heightnew = 0.0f + maxY * 2.0f;
            tess.func_78374_a((double)(minX + 0.0f), (double)(minY + maxY), 0.0, 0.0, heightnew);
            tess.func_78374_a((double)(minX + width), (double)(minY + maxY), 0.0, widthnew, heightnew);
            tess.func_78374_a((double)(minX + width), (double)(minY + 0.0f), 0.0, widthnew, 0.0);
            tess.func_78374_a((double)(minX + 0.0f), (double)(minY + 0.0f), 0.0, 0.0, 0.0);
            tess.func_78381_a();
        }
        GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
        GL11.glTranslatef((float)(minX + (maxX - minX) / 2.0f), (float)(minY + maxY / 2.0f), (float)0.01f);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        GL11.glTranslated((double)0.0, (double)((scale - 40.0f) / 5.0f + 4.0f), (double)0.0);
        String data = this.getDisplayableData();
        rend.func_78276_b(data, -(rend.func_78256_a(data) / 2), 0, -1);
    }

    @Override
    public boolean isEqualType(Info info) {
        if (info != null && info.getName().equals(this.getName())) {
            return info.getCategory().equals(this.getCategory()) && info.getSubCategory().equals(this.getSubCategory());
        }
        return false;
    }

    @Override
    public void emptyData() {
    }

    public ProgressInfo newInfo() {
        return new ProgressInfo();
    }
}

