/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import sonar.logistics.api.Info;
import sonar.logistics.client.renderers.RenderHandlers;
import sonar.logistics.info.providers.tile.ManaProvider;
import sonar.logistics.info.types.ProgressInfo;

public class ManaInfo
extends ProgressInfo {
    private static final ResourceLocation progress = new ResourceLocation(RenderHandlers.modelFolder + "progressBar.png");
    public long stored;
    public long max;
    public int providerID = -1;

    public ManaInfo() {
    }

    public ManaInfo(int providerID, long stored, long max) {
        this.stored = stored;
        this.max = max;
        this.providerID = providerID;
        this.data = " ";
    }

    @Override
    public String getName() {
        return "ManaBar";
    }

    @Override
    public byte getProviderID() {
        return (byte)this.providerID;
    }

    @Override
    public String getCategory() {
        return new ManaProvider().getCategory((byte)0);
    }

    @Override
    public String getSubCategory() {
        return "Mana";
    }

    @Override
    public String getData() {
        return String.valueOf(this.stored);
    }

    @Override
    public String getDisplayableData() {
        return "-";
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.stored = buf.readLong();
        this.max = buf.readLong();
        this.providerID = buf.readByte();
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeLong(this.stored);
        buf.writeLong(this.max);
        buf.writeByte(this.providerID);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stored = tag.func_74763_f("stored");
        this.max = tag.func_74763_f("max");
        this.providerID = tag.func_74771_c("ID");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74772_a("stored", this.stored);
        tag.func_74772_a("max", this.max);
        tag.func_74774_a("ID", (byte)this.providerID);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, float scale) {
        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslated((double)0.0, (double)0.0, (double)zOffset);
        float width = (float)this.stored * (maxX - minX) / (float)this.max;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(progress);
        tess.func_78382_b();
        double widthnew = 0.0f + width * 2.0f;
        double heightnew = 0.0f + maxY * 2.0f;
        tess.func_78374_a((double)(minX + 0.0f), (double)(minY + maxY), 0.0, 0.0, heightnew);
        tess.func_78374_a((double)(minX + width), (double)(minY + maxY), 0.0, widthnew, heightnew);
        tess.func_78374_a((double)(minX + width), (double)(minY + 0.0f), 0.0, widthnew, 0.0);
        tess.func_78374_a((double)(minX + 0.0f), (double)(minY + 0.0f), 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
        GL11.glTranslatef((float)(minX + (maxX - minX) / 2.0f), (float)(minY + maxY / 2.0f), (float)0.01f);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        GL11.glTranslated((double)0.0, (double)((scale - 40.0f) / 5.0f + 4.0f), (double)0.0);
        String data = this.getSubCategory();
        rend.func_78276_b(data, -(rend.func_78256_a(data) / 2), 0, -1);
    }

    @Override
    public boolean isEqualType(Info info) {
        if (info != null && info.getName().equals(this.getName())) {
            return info.getCategory().equals(this.getCategory()) && info.getSubCategory().equals(this.getSubCategory());
        }
        return false;
    }

    @Override
    public void emptyData() {
    }

    @Override
    public ManaInfo newInfo() {
        return new ManaInfo();
    }
}

