/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;
import sonar.logistics.api.StandardInfo;

public class FluidInfo
extends StandardInfo {
    public int fluidID = -1;

    @Override
    public String getName() {
        return "Fluid-Info";
    }

    public FluidInfo() {
    }

    public FluidInfo(byte providerID, String category, String subCategory, Object data, String suffix, int fluidID) {
        super(providerID, category, subCategory, data, suffix);
        this.fluidID = fluidID;
    }

    public FluidInfo(byte providerID, String category, String subCategory, Object data, int fluidID) {
        super((int)providerID, category, subCategory, data);
        this.fluidID = fluidID;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        super.readFromBuf(buf);
        this.fluidID = buf.readInt();
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        super.writeToBuf(buf);
        buf.writeInt(this.fluidID);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.fluidID = tag.func_74762_e("fluidID");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("fluidID", this.fluidID);
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, float scale) {
        IIcon icon;
        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslated((double)0.0, (double)0.0, (double)zOffset);
        float width = maxX - minX;
        boolean renderNormal = true;
        if (this.fluidID != -1 && FluidRegistry.getFluid((int)this.fluidID) != null && (icon = FluidRegistry.getFluid((int)this.fluidID).getIcon()) != null) {
            renderNormal = false;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            tess.func_78382_b();
            double divide = Math.max(0.5 + (double)minX + (double)(maxX - minX), 0.5 + (double)(maxY - minY));
            double widthnew = (double)icon.func_94209_e() + (double)(width * (icon.func_94212_f() - icon.func_94209_e())) / divide;
            double heightnew = (double)icon.func_94206_g() + (double)(maxY * (icon.func_94210_h() - icon.func_94206_g())) / divide;
            tess.func_78374_a((double)(minX + 0.0f), (double)(minY + maxY), 0.0, (double)icon.func_94209_e(), heightnew);
            tess.func_78374_a((double)(minX + width), (double)(minY + maxY), 0.0, widthnew, heightnew);
            tess.func_78374_a((double)(minX + width), (double)(minY + 0.0f), 0.0, widthnew, (double)icon.func_94206_g());
            tess.func_78374_a((double)(minX + 0.0f), (double)(minY + 0.0f), 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tess.func_78381_a();
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-zOffset));
        super.renderInfo(tess, tile, minX, minY, maxX, maxY, zOffset, scale);
    }

    @Override
    public FluidInfo newInfo() {
        return new FluidInfo();
    }
}

