/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.utils.BlockCoords;
import sonar.logistics.api.Info;

public class BlockCoordsInfo
extends Info {
    public boolean emptyData;
    public String name;
    public BlockCoords coords;

    public static Info createInfo(String name, BlockCoords coords) {
        BlockCoordsInfo info = new BlockCoordsInfo();
        info.name = name;
        info.coords = coords;
        return info;
    }

    @Override
    public String getName() {
        return "Coords";
    }

    @Override
    public byte getProviderID() {
        return -1;
    }

    @Override
    public String getCategory() {
        return this.name;
    }

    @Override
    public String getSubCategory() {
        return this.name;
    }

    @Override
    public String getData() {
        return this.coords.getRender();
    }

    @Override
    public String getDisplayableData() {
        return this.getData();
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.coords = BlockCoords.readFromBuf((ByteBuf)buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        BlockCoords.writeToBuf((ByteBuf)buf, (BlockCoords)this.coords);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.name = tag.func_74779_i("name");
        this.coords = BlockCoords.readFromNBT((NBTTagCompound)tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        BlockCoords.writeToNBT((NBTTagCompound)tag, (BlockCoords)this.coords);
    }

    @Override
    public boolean isEqualType(Info info) {
        if (info != null && info instanceof BlockCoordsInfo) {
            BlockCoordsInfo coordInfo = (BlockCoordsInfo)info;
            return info.getCategory().equals(this.name) && BlockCoords.equalCoords((BlockCoords)coordInfo.coords, (BlockCoords)this.coords);
        }
        return false;
    }

    @Override
    public void emptyData() {
    }

    public BlockCoordsInfo newInfo() {
        return new BlockCoordsInfo();
    }
}

