/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.providers.TileProvider;
import sonar.logistics.info.types.ThaumcraftAspectInfo;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.nodes.INode;

public class ThaumcraftProvider
extends TileProvider {
    public static String name = "Thaumcraft-Provider";
    public String[] categories = new String[]{"THAUMCRAFT ASPECTS", "THAUMCRAFT NODE"};
    public String[] subcategories = new String[]{"Has Primal Aspect", "Modifier", "Type"};

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        if (target != null) {
            if (target instanceof IAspectContainer) {
                return true;
            }
            if (target instanceof INode) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void getHelperInfo(List<Info> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        byte id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        if (target != null) {
            if (target instanceof IAspectContainer) {
                IAspectContainer container = (IAspectContainer)target;
                Aspect[] list = container.getAspects().getAspects();
                if (target instanceof INode) {
                    INode node = (INode)target;
                    list = node.getAspectsBase().getAspects();
                }
                if (list != null) {
                    boolean hasPrimal = false;
                    for (int i = 0; i < list.length; ++i) {
                        Aspect aspect = list[i];
                        if (aspect == null) continue;
                        if (aspect.isPrimal()) {
                            hasPrimal = true;
                        }
                        int contains = container.containerContains(aspect);
                        if (target instanceof INode) {
                            INode node = (INode)target;
                            contains = node.getNodeVisBase(aspect);
                        }
                        infoList.add(new ThaumcraftAspectInfo(id, "THAUMCRAFT ASPECTS", aspect.getName(), (Object)contains, aspect.getTag()));
                    }
                    infoList.add(new StandardInfo((int)id, 0, 0, (Object)hasPrimal));
                }
            }
            if (target instanceof INode) {
                INode node = (INode)target;
                if (node.getNodeModifier() != null) {
                    infoList.add(new StandardInfo((int)id, 1, 1, (Object)node.getNodeModifier().name()));
                }
                if (node.getNodeType() != null) {
                    infoList.add(new StandardInfo((int)id, 1, 2, (Object)node.getNodeType().name()));
                }
            }
        }
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"Thaumcraft");
    }

    @Override
    public String getCategory(byte id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(byte id) {
        return this.subcategories[id];
    }
}

