/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.providers.TileProvider;

public class RFEnergyProvider
extends TileProvider {
    public static String name = "Redstone-Flux";
    public String[] categories = new String[]{"ENERGY RF"};
    public String[] subcategories = new String[]{"Connects: ", "Current", "Max Energy", "Stored", "Max Stored"};

    @Override
    public String getName() {
        return "Redstone-Flux";
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && target instanceof IEnergyConnection;
    }

    @Override
    public void getHelperInfo(List<Info> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        IEnergyConnection info;
        byte id = this.getID();
        TileEntity handler = world.func_147438_o(x, y, z);
        if (handler instanceof IEnergyConnection) {
            info = (IEnergyConnection)handler;
            boolean canConnect = info.canConnectEnergy(dir);
            infoList.add(new StandardInfo((int)id, 0, 0, (Object)("" + canConnect)));
        }
        if (handler instanceof IEnergyStorage) {
            info = (IEnergyStorage)handler;
            infoList.add(new StandardInfo(id, 0, 1, (Object)info.getEnergyStored(), "RF"));
            infoList.add(new StandardInfo(id, 0, 2, (Object)info.getMaxEnergyStored(), "RF"));
        } else if (handler instanceof IEnergyHandler) {
            info = (IEnergyHandler)handler;
            int energyStored = info.getEnergyStored(dir);
            int maxStored = info.getMaxEnergyStored(dir);
            if (maxStored != 0) {
                infoList.add(new StandardInfo(id, 0, 3, (Object)energyStored, "RF"));
                infoList.add(new StandardInfo(id, 0, 4, (Object)maxStored, "RF"));
            }
        }
    }

    @Override
    public String getCategory(byte id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(byte id) {
        return this.subcategories[id];
    }
}

