/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import buildcraft.api.power.ILaserTarget;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.tiles.IHeatable;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.providers.TileProvider;

public class BuildcraftProvider
extends TileProvider {
    public static String name = "Buildcraft-Provider";
    public static String[] categories = new String[]{"Buildcraft: General", "Buildcraft: Lasers"};
    public static String[] subcategories = new String[]{"Active", "Current Heat", "Min Heat", "Max Heat", "Ideal Heat", "Requires Energy", "Valid Target"};

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && (te instanceof IHasWork || te instanceof IHeatable || te instanceof ILaserTarget);
    }

    @Override
    public void getHelperInfo(List<Info> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        byte id = this.getID();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        if (te instanceof IHasWork) {
            IHasWork worker = (IHasWork)te;
            infoList.add(new StandardInfo((int)id, 0, 0, (Object)worker.hasWork()));
        }
        if (te instanceof IHeatable) {
            IHeatable heat = (IHeatable)te;
            infoList.add(new StandardInfo(id, 0, 1, (Object)((int)heat.getCurrentHeatValue()), " degrees"));
            infoList.add(new StandardInfo(id, 0, 2, (Object)((int)heat.getMinHeatValue()), " degrees"));
            infoList.add(new StandardInfo(id, 0, 3, (Object)((int)heat.getMaxHeatValue()), " degrees"));
            infoList.add(new StandardInfo(id, 0, 4, (Object)((int)heat.getIdealHeatValue()), " degrees"));
        }
        if (te instanceof ILaserTarget) {
            ILaserTarget laser = (ILaserTarget)te;
            infoList.add(new StandardInfo((int)id, 1, 5, (Object)laser.requiresLaserEnergy()));
            infoList.add(new StandardInfo((int)id, 1, 6, (Object)laser.isInvalidTarget()));
        }
    }

    @Override
    public String getCategory(byte id) {
        return categories[id];
    }

    @Override
    public String getSubCategory(byte id) {
        return subcategories[id];
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"BuildCraft|Core");
    }
}

