/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.providers.tile;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.providers.TileProvider;

public class AE2GridProvider
extends TileProvider {
    public static String name = "AE2-Grid-Provider";
    public String[] categories = new String[]{"AE2 Energy", "AE2 Channels"};
    public String[] subcategories = new String[]{"Idle Power Usage", "Used Channels", "Is Active", "Is Powered"};

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideInfo(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity target = world.func_147438_o(x, y, z);
        return target != null && (target instanceof IGridBlock || target instanceof IGridConnection || target instanceof IPowerChannelState);
    }

    @Override
    public void getHelperInfo(List<Info> infoList, World world, int x, int y, int z, ForgeDirection dir) {
        IGridBlock grid;
        byte id = this.getID();
        TileEntity target = world.func_147438_o(x, y, z);
        if (target instanceof IGridBlock) {
            grid = (IGridBlock)target;
            infoList.add(new StandardInfo(id, 0, 0, (Object)((int)grid.getIdlePowerUsage()), "ae/t"));
        }
        if (target instanceof IGridConnection) {
            grid = (IGridConnection)target;
            infoList.add(new StandardInfo((int)id, 1, 1, (Object)grid.getUsedChannels()));
        }
        if (target instanceof IPowerChannelState) {
            grid = (IPowerChannelState)target;
            infoList.add(new StandardInfo((int)id, 1, 2, (Object)grid.isActive()));
            infoList.add(new StandardInfo((int)id, 1, 3, (Object)grid.isPowered()));
        }
    }

    @Override
    public String getCategory(byte id) {
        return this.categories[id];
    }

    @Override
    public String getSubCategory(byte id) {
        return this.subcategories[id];
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"appliedenergistics2");
    }
}

