/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.inventory.StoredItemStack;
import sonar.core.utils.helpers.SonarHelper;
import sonar.logistics.Logistics;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.providers.EntityProvider;
import sonar.logistics.api.providers.InventoryProvider;
import sonar.logistics.api.providers.TileProvider;
import sonar.logistics.common.tileentity.TileEntityBlockNode;
import sonar.logistics.common.tileentity.TileEntityEntityNode;
import sonar.logistics.info.types.CategoryInfo;
import sonar.logistics.info.types.FluidInfo;
import sonar.logistics.info.types.ProgressInfo;

public class InfoHelper {
    public static List<Info> getTileInfo(TileEntityBlockNode tileNode) {
        List providers = Logistics.tileProviders.getObjects();
        ArrayList<Info> providerInfo = new ArrayList<Info>();
        for (TileProvider provider : providers) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)SonarHelper.invertMetadata((int)tileNode.func_145832_p())).getOpposite();
            if (!provider.canProvideInfo(tileNode.func_145831_w(), tileNode.field_145851_c + dir.offsetX, tileNode.field_145848_d + dir.offsetY, tileNode.field_145849_e + dir.offsetZ, dir)) continue;
            ArrayList<Info> info = new ArrayList<Info>();
            provider.getHelperInfo(info, tileNode.func_145831_w(), tileNode.field_145851_c + dir.offsetX, tileNode.field_145848_d + dir.offsetY, tileNode.field_145849_e + dir.offsetZ, dir);
            for (Info blockInfo : info) {
                providerInfo.add(blockInfo);
            }
        }
        Collections.sort(providerInfo, new Comparator<Info>(){

            @Override
            public int compare(Info str1, Info str2) {
                int res = String.CASE_INSENSITIVE_ORDER.compare(str1.getCategory(), str2.getCategory());
                if (res == 0) {
                    res = str1.getCategory().compareTo(str2.getCategory());
                }
                return res;
            }
        });
        return providerInfo;
    }

    public static List<Info> getEntityInfo(TileEntityEntityNode tileNode) {
        List providers = Logistics.entityProviders.getObjects();
        ArrayList<Info> providerInfo = new ArrayList<Info>();
        Entity entity = tileNode.getNearestEntity();
        if (entity == null) {
            return null;
        }
        for (EntityProvider provider : providers) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)SonarHelper.invertMetadata((int)tileNode.func_145832_p())).getOpposite();
            if (!provider.canProvideInfo(entity)) continue;
            ArrayList<Info> info = new ArrayList<Info>();
            provider.getHelperInfo(info, entity);
            for (Info blockInfo : info) {
                providerInfo.add(blockInfo);
            }
        }
        Collections.sort(providerInfo, new Comparator<Info>(){

            @Override
            public int compare(Info str1, Info str2) {
                int res = String.CASE_INSENSITIVE_ORDER.compare(str1.getCategory(), str2.getCategory());
                if (res == 0) {
                    res = str1.getCategory().compareTo(str2.getCategory());
                }
                return res;
            }
        });
        return providerInfo;
    }

    public static Info getLatestTileInfo(Info blockInfo, TileEntityBlockNode tileNode) {
        if (blockInfo == null) {
            return null;
        }
        TileProvider provider = (TileProvider)Logistics.tileProviders.getRegisteredObject(blockInfo.getProviderID());
        if (provider != null) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)SonarHelper.invertMetadata((int)tileNode.func_145832_p())).getOpposite();
            ArrayList<Info> info = new ArrayList<Info>();
            provider.getHelperInfo(info, tileNode.func_145831_w(), tileNode.field_145851_c + dir.offsetX, tileNode.field_145848_d + dir.offsetY, tileNode.field_145849_e + dir.offsetZ, dir);
            for (Info currentInfo : info) {
                if (!currentInfo.isEqualType(blockInfo)) continue;
                return currentInfo;
            }
        }
        blockInfo.emptyData();
        return blockInfo;
    }

    public static Info getLatestEntityInfo(Info blockInfo, TileEntityEntityNode tileNode) {
        if (blockInfo == null) {
            return null;
        }
        Entity entity = tileNode.getNearestEntity();
        if (entity == null) {
            return null;
        }
        EntityProvider provider = (EntityProvider)Logistics.entityProviders.getRegisteredObject(blockInfo.getProviderID());
        if (provider != null) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)SonarHelper.invertMetadata((int)tileNode.func_145832_p())).getOpposite();
            ArrayList<Info> info = new ArrayList<Info>();
            provider.getHelperInfo(info, entity);
            for (Info currentInfo : info) {
                if (!currentInfo.isEqualType(blockInfo)) continue;
                return currentInfo;
            }
        }
        blockInfo.emptyData();
        return blockInfo;
    }

    public static List<StoredItemStack> getTileInventory(TileEntityBlockNode tileNode) {
        ArrayList<StoredItemStack> storedStacks = new ArrayList<StoredItemStack>();
        ForgeDirection dir = ForgeDirection.getOrientation((int)SonarHelper.invertMetadata((int)tileNode.func_145832_p())).getOpposite();
        TileEntity tile = tileNode.func_145831_w().func_147438_o(tileNode.field_145851_c + dir.offsetX, tileNode.field_145848_d + dir.offsetY, tileNode.field_145849_e + dir.offsetZ);
        if (tile == null) {
            return storedStacks;
        }
        boolean specialProvider = false;
        for (InventoryProvider provider : Logistics.inventoryProviders.getObjects()) {
            if (!provider.canProvideItems(tileNode.func_145831_w(), tileNode.field_145851_c + dir.offsetX, tileNode.field_145848_d + dir.offsetY, tileNode.field_145849_e + dir.offsetZ, dir)) continue;
            specialProvider = provider.getItems(storedStacks, tileNode.func_145831_w(), tileNode.field_145851_c + dir.offsetX, tileNode.field_145848_d + dir.offsetY, tileNode.field_145849_e + dir.offsetZ, dir);
        }
        if (!specialProvider && tile instanceof IInventory) {
            InfoHelper.addInventoryToList(storedStacks, (IInventory)tile);
        }
        Collections.sort(storedStacks, new Comparator<StoredItemStack>(){

            @Override
            public int compare(StoredItemStack str1, StoredItemStack str2) {
                if (str1.stored < str2.stored) {
                    return 1;
                }
                if (str1.stored == str2.stored) {
                    return 0;
                }
                return -1;
            }
        });
        return storedStacks;
    }

    public static List<StoredItemStack> getEntityInventory(TileEntityEntityNode tileNode) {
        ArrayList<StoredItemStack> storedStacks = new ArrayList<StoredItemStack>();
        Entity entity = tileNode.getNearestEntity();
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            InfoHelper.addInventoryToList(storedStacks, (IInventory)player.field_71071_by);
        } else if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            InfoHelper.addInventoryToList(storedStacks, (IInventory)player.field_71071_by);
        }
        Collections.sort(storedStacks, new Comparator<StoredItemStack>(){

            @Override
            public int compare(StoredItemStack str1, StoredItemStack str2) {
                if (str1.stored < str2.stored) {
                    return 1;
                }
                if (str1.stored == str2.stored) {
                    return 0;
                }
                return -1;
            }
        });
        return storedStacks;
    }

    public static void addInventoryToList(List<StoredItemStack> list, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            InfoHelper.addStackToList(list, inv.func_70301_a(i));
        }
    }

    public static void addStackToList(List<StoredItemStack> list, ItemStack stack) {
        boolean added = false;
        int pos = 0;
        for (StoredItemStack storedStack : list) {
            if (storedStack.equalStack(stack)) {
                list.get(pos).add(stack);
                added = true;
            }
            ++pos;
        }
        if (!added) {
            list.add(new StoredItemStack(stack));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Info combineData(Info primary, Info secondary) {
        if (primary instanceof CategoryInfo || secondary instanceof CategoryInfo) return new StandardInfo(-1, primary.getCategory(), "Combined Data", (Object)(primary.getDisplayableData() + secondary.getDisplayableData()));
        if (primary.getDataType() != 0 || secondary.getDataType() != 0) return primary;
        int stored = Integer.parseInt(secondary.getData());
        int max = Integer.parseInt(primary.getData());
        if (stored < 0 || max < 0) {
            return primary;
        }
        int fluidId = -1;
        if (primary instanceof FluidInfo) {
            FluidInfo fluidinfo = (FluidInfo)primary;
            fluidId = fluidinfo.fluidID;
        }
        if (stored > max && stored != 0) {
            return new ProgressInfo(max, stored, primary.getDisplayableData(), fluidId);
        }
        if (max == 0) return primary;
        return new ProgressInfo(stored, max, secondary.getDisplayableData(), fluidId);
    }

    public static Info readInfo(ByteBuf buf) {
        if (buf.readBoolean()) {
            String type = ByteBufUtils.readUTF8String((ByteBuf)buf);
            if (Logistics.infoTypes.getRegisteredObject(type) == null) {
                Logistics.logger.warn("Unregistered Info Type: " + type);
                return null;
            }
            Object info = ((Info)Logistics.infoTypes.getRegisteredObject(type)).newInfo();
            ((Info)info).readFromBuf(buf);
            return info;
        }
        return null;
    }

    public static void writeInfo(ByteBuf buf, Info info) {
        if (info != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)info.getName());
            info.writeToBuf(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Info readInfo(NBTTagCompound tag) {
        if (tag.func_74764_b("type")) {
            String type = tag.func_74779_i("type");
            if (type.equals("NULLED")) {
                return null;
            }
            if (Logistics.infoTypes.getRegisteredObject(type) == null) {
                Logistics.logger.warn("Unregistered Info Type: " + type);
                return null;
            }
            Object info = ((Info)Logistics.infoTypes.getRegisteredObject(type)).newInfo();
            ((Info)info).readFromNBT(tag);
            return info;
        }
        return null;
    }

    public static void writeInfo(NBTTagCompound tag, Info info) {
        if (info != null) {
            tag.func_74778_a("type", info.getName());
            info.writeToNBT(tag);
        } else {
            tag.func_74778_a("type", "NULLED");
        }
    }
}

