/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.fluid.StoredFluidStack;
import sonar.core.utils.helpers.SonarHelper;
import sonar.logistics.Logistics;
import sonar.logistics.api.providers.FluidProvider;
import sonar.logistics.common.tileentity.TileEntityBlockNode;

public class FluidHelper {
    public static List<StoredFluidStack> getFluids(TileEntityBlockNode tileNode) {
        ArrayList<StoredFluidStack> fluidList = new ArrayList<StoredFluidStack>();
        List providers = Logistics.fluidProviders.getObjects();
        for (FluidProvider provider : providers) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)SonarHelper.invertMetadata((int)tileNode.func_145832_p())).getOpposite();
            if (!provider.canProvideFluids(tileNode.func_145831_w(), tileNode.field_145851_c + dir.offsetX, tileNode.field_145848_d + dir.offsetY, tileNode.field_145849_e + dir.offsetZ, dir)) continue;
            ArrayList<StoredFluidStack> info = new ArrayList<StoredFluidStack>();
            provider.getFluids(info, tileNode.func_145831_w(), tileNode.field_145851_c + dir.offsetX, tileNode.field_145848_d + dir.offsetY, tileNode.field_145849_e + dir.offsetZ, dir);
            for (StoredFluidStack fluid : info) {
                FluidHelper.addFluidToList(fluidList, fluid);
            }
        }
        Collections.sort(fluidList, new Comparator<StoredFluidStack>(){

            @Override
            public int compare(StoredFluidStack str1, StoredFluidStack str2) {
                if (str1.stored < str2.stored) {
                    return 1;
                }
                if (str1.stored == str2.stored) {
                    return 0;
                }
                return -1;
            }
        });
        return fluidList;
    }

    public static void addFluidToList(List<StoredFluidStack> list, StoredFluidStack stack) {
        boolean added = false;
        int pos = 0;
        for (StoredFluidStack storedTank : list) {
            if (storedTank.equalStack(stack.fluid)) {
                list.get(pos).add(stack);
                added = true;
            }
            ++pos;
        }
        if (!added) {
            list.add(stack);
        }
    }
}

