/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.utils.BlockCoords;
import sonar.logistics.api.connecting.ILargeDisplay;
import sonar.logistics.api.render.LargeScreenSizing;

public class DisplayHelper {
    public static void onDisplayAdded(TileEntity tile) {
        TileHandler tileObj = FMPHelper.getHandler((Object)tile);
        if (tileObj == null || !(tileObj instanceof ILargeDisplay)) {
            return;
        }
        ILargeDisplay added = (ILargeDisplay)tileObj;
        ForgeDirection forward = ForgeDirection.getOrientation((int)tile.field_145847_g);
        BlockCoords handlerCoords = null;
        int connectedSize = -1;
        int listPos = -1;
        ILargeDisplay[] handlers = new ILargeDisplay[6];
        BlockCoords[] coordsList = new BlockCoords[6];
        for (int i = 0; i < 6; ++i) {
            TileHandler handTarg;
            BlockCoords coords;
            TileHandler target;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (dir == forward && dir == forward.getOpposite() || !((target = FMPHelper.getHandler((Object)(coords = new BlockCoords(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ)).getTileEntity(tile.func_145831_w()))) instanceof ILargeDisplay)) continue;
            ILargeDisplay display = (ILargeDisplay)target;
            if (display.isHandler()) {
                if (display.getConnectedScreens().size() > connectedSize) {
                    handlerCoords = coords;
                    connectedSize = display.getConnectedScreens().size();
                    listPos = i;
                }
                handlers[i] = display;
                coordsList[i] = coords;
                continue;
            }
            BlockCoords handler = display.getHandlerCoords();
            if (handler == null || (handTarg = FMPHelper.getHandler((Object)handler.getTileEntity(tile.func_145831_w()))) == null || !(handTarg instanceof ILargeDisplay)) continue;
            ILargeDisplay handlerDis = (ILargeDisplay)handTarg;
            if (handlerDis.getConnectedScreens().size() > connectedSize) {
                handlerCoords = handler;
                connectedSize = handlerDis.getConnectedScreens().size();
                listPos = i;
            }
            handlers[i] = handlerDis;
            coordsList[i] = handler;
        }
        if (handlerCoords != null) {
            added.setHandlerCoords(handlerCoords);
            added.setHandler(false);
            TileHandler handTarg = FMPHelper.getHandler((Object)handlerCoords.getTileEntity(tile.func_145831_w()));
            if (handTarg != null && handTarg instanceof ILargeDisplay) {
                ILargeDisplay handlerDis = (ILargeDisplay)handTarg;
                handlerDis.addDisplay(new BlockCoords(tile));
            }
        } else {
            added.setHandler(true);
            added.addDisplay(new BlockCoords(tile));
        }
    }

    public static void onDisplayRemoved(TileEntity tile) {
        Object tileObj = FMPHelper.checkObject((Object)tile);
        if (!(tileObj instanceof ILargeDisplay)) {
            tileObj = FMPHelper.getHandler((Object)tileObj);
        }
        if (tileObj == null || !(tileObj instanceof ILargeDisplay)) {
            return;
        }
        ILargeDisplay remove = (ILargeDisplay)tileObj;
        if (remove.isHandler() && remove.getConnectedScreens() != null || !remove.getConnectedScreens().isEmpty()) {
            BlockCoords coords = remove.getConnectedScreens().get(0);
            if (coords != null) {
                Object target = FMPHelper.checkObject((Object)coords.getTileEntity(tile.func_145831_w()));
                if (!(target instanceof ILargeDisplay)) {
                    target = FMPHelper.getHandler((Object)target);
                }
                if (target instanceof ILargeDisplay) {
                    ILargeDisplay display = (ILargeDisplay)target;
                    remove.removeDisplay(new BlockCoords(tile));
                    display.setHandlerCoords(coords);
                    display.setConnectedScreens(remove.getConnectedScreens());
                    display.setHandler(true);
                }
            }
        } else {
            BlockCoords handler = remove.getHandlerCoords();
            if (handler == null) {
                return;
            }
            Object target = FMPHelper.checkObject((Object)handler.getTileEntity(tile.func_145831_w()));
            if (!(target instanceof ILargeDisplay)) {
                target = FMPHelper.getHandler((Object)target);
            }
            if (target instanceof ILargeDisplay) {
                ILargeDisplay display = (ILargeDisplay)target;
                display.removeDisplay(new BlockCoords(tile));
            }
        }
    }

    public static LargeScreenSizing getScreenSizing(TileEntity tile) {
        int minH;
        Object tileObj = FMPHelper.checkObject((Object)tile);
        if (!(tileObj instanceof ILargeDisplay)) {
            tileObj = FMPHelper.getHandler((Object)tileObj);
        }
        if (tileObj == null || !(tileObj instanceof ILargeDisplay)) {
            return null;
        }
        ILargeDisplay remove = (ILargeDisplay)tileObj;
        if (!remove.isHandler()) {
            return null;
        }
        int maxX = tile.field_145851_c;
        int maxY = tile.field_145848_d;
        int maxZ = tile.field_145849_e;
        int minX = tile.field_145851_c;
        int minY = tile.field_145848_d;
        int minZ = tile.field_145849_e;
        int meta = tile.func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta).getRotation(ForgeDirection.UP);
        boolean north = false;
        if (dir.offsetX == -1 || dir.offsetX == 1) {
            north = true;
        }
        int screens = 0;
        for (BlockCoords coords : remove.getConnectedScreens()) {
            ++screens;
            if (coords.getX() > maxX) {
                maxX = coords.getX();
            } else if (coords.getX() < minX) {
                minX = coords.getX();
            }
            if (coords.getY() > maxY) {
                maxY = coords.getY();
            } else if (coords.getY() < minY) {
                minY = coords.getY();
            }
            if (coords.getZ() > maxZ) {
                maxZ = coords.getZ();
                continue;
            }
            if (coords.getZ() >= minZ) continue;
            minZ = coords.getZ();
        }
        int maxH = north ? maxX : maxZ;
        for (int h = minH = north ? minX : minZ; h <= maxH; ++h) {
            for (int y = minY; y <= maxY; ++y) {
                BlockCoords coords = new BlockCoords(north ? h : tile.field_145851_c, y, !north ? h : tile.field_145849_e);
                TileEntity target = coords.getTileEntity(tile.func_145831_w());
                TileHandler targetObj = FMPHelper.getHandler((Object)target);
                if (targetObj != null && targetObj instanceof ILargeDisplay && target.func_145832_p() == meta) continue;
                return null;
            }
        }
        minY = tile.field_145848_d - minY;
        return new LargeScreenSizing(maxY -= tile.field_145848_d, minY, maxH -= north ? tile.field_145851_c : tile.field_145849_e, minH -= north ? tile.field_145851_c : tile.field_145849_e);
    }
}

