/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.helpers;

import codechicken.multipart.TileMultipart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.SonarAPI;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.SonarHelper;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.api.connecting.IDataConnection;
import sonar.logistics.api.connecting.IDataReceiver;
import sonar.logistics.api.connecting.IDataTile;
import sonar.logistics.common.tileentity.TileEntityDataEmitter;

public class CableHelper {
    public static void updateAdjacentCoords(TileEntity tile, BlockCoords coords, boolean overwrite) {
        CableHelper.updateAdjacentCoords(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, coords, overwrite);
    }

    public static void updateAdjacentCoords(World world, int x, int y, int z, BlockCoords newCoords, boolean overwrite) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            CableHelper.updateAdjacentCoord(world, x, y, z, newCoords, overwrite, dir);
        }
    }

    public static void updateAdjacentCoords(TileEntity tile, BlockCoords coords, boolean overwrite, ForgeDirection[] remove) {
        CableHelper.updateAdjacentCoords(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, coords, overwrite, remove);
    }

    public static void updateAdjacentCoords(World world, int x, int y, int z, BlockCoords newCoords, boolean overwrite, ForgeDirection[] remove) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (remove != null) {
                for (int d = 0; d < remove.length; ++d) {
                    if (dir.equals((Object)remove[d])) continue;
                    CableHelper.updateAdjacentCoord(world, x, y, z, newCoords, overwrite, dir);
                }
                continue;
            }
            CableHelper.updateAdjacentCoord(world, x, y, z, newCoords, overwrite, dir);
        }
    }

    public static void updateAdjacentCoord(TileEntity tile, BlockCoords coords, boolean overwrite, ForgeDirection dir) {
        CableHelper.updateAdjacentCoord(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, coords, overwrite, dir);
    }

    public static void updateAdjacentCoord(World world, int x, int y, int z, BlockCoords newCoords, boolean overwrite, ForgeDirection dir) {
        Object tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        Object originTile = world.func_147438_o(x, y, z);
        tile = FMPHelper.checkObject((Object)tile);
        originTile = FMPHelper.checkObject((Object)originTile);
        if (tile != null && tile instanceof IDataCable) {
            IDataCable originCable;
            IDataCable cable = (IDataCable)tile;
            if (originTile != null && originTile instanceof IDataCable && (originCable = (IDataCable)originTile).isBlocked(dir)) {
                return;
            }
            if (!cable.isBlocked(dir.getOpposite())) {
                if (cable.getCoords() == null || overwrite && newCoords == null) {
                    cable.setCoords(newCoords);
                } else if (overwrite && !BlockCoords.equalCoords((BlockCoords)cable.getCoords(), (BlockCoords)newCoords)) {
                    cable.setCoords(newCoords);
                }
            }
        }
    }

    public static void removeAllBlockedAdjacentCoords(TileEntity tile) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            Object target = tile.func_145831_w().func_147438_o(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ);
            if ((target = FMPHelper.checkObject((Object)target)) == null || !(target instanceof IDataCable)) continue;
            IDataCable cable = (IDataCable)target;
            cable.setCoords(null);
        }
    }

    public static Object getConnectedTile(TileEntity tile, ForgeDirection dir) {
        Object emitterBlock;
        IDataCable cable;
        Object target = SonarHelper.getAdjacentTileEntity((TileEntity)tile, (ForgeDirection)dir);
        if ((target = FMPHelper.checkObject((Object)target)) == null) {
            return null;
        }
        if (target instanceof IDataCable && !(cable = (IDataCable)target).isBlocked(dir.getOpposite()) && cable.getCoords() != null) {
            Object dataProvider = cable.getCoords().getTileEntity(tile.func_145831_w());
            if ((dataProvider = FMPHelper.checkObject((Object)dataProvider)) != null) {
                if (dataProvider instanceof IDataReceiver) {
                    Object emitterBlock2 = CableHelper.getConnectedEmitter((IDataReceiver)target, tile);
                    if (emitterBlock2 != null) {
                        return emitterBlock2;
                    }
                } else if (dataProvider instanceof IDataConnection) {
                    return dataProvider;
                }
            }
        }
        if (target instanceof IDataReceiver && (emitterBlock = CableHelper.getConnectedEmitter((IDataReceiver)target, tile)) != null) {
            return emitterBlock;
        }
        if (target instanceof IDataConnection && ((IDataConnection)target).canConnect(dir.getOpposite())) {
            return target;
        }
        if (SonarAPI.forgeMultipartLoaded() && target instanceof TileMultipart) {
            return target;
        }
        return null;
    }

    public static Object getConnectedEmitter(IDataReceiver receiver, TileEntity tile) {
        if (receiver.getEmitter() != null) {
            TileEntity emitter = receiver.getEmitter().coords.getTileEntity();
            if (emitter instanceof TileEntityDataEmitter) {
                TileEntityDataEmitter dataemitter = (TileEntityDataEmitter)emitter;
                if (tile.field_145851_c != dataemitter.field_145851_c || tile.field_145848_d != dataemitter.field_145848_d || tile.field_145849_e != dataemitter.field_145849_e) {
                    return dataemitter.getConnectedTile();
                }
            }
            if (emitter != null) {
                return emitter;
            }
        }
        return null;
    }

    public static boolean canRenderConnection(TileEntity te, ForgeDirection dir) {
        Object tile = SonarHelper.getAdjacentTileEntity((TileEntity)te, (ForgeDirection)dir);
        if ((tile = FMPHelper.checkObject((Object)tile)) != null) {
            IDataCable cable;
            if (tile instanceof IDataTile) {
                return ((IDataTile)tile).canConnect(dir.getOpposite());
            }
            if (tile instanceof IDataCable && !(cable = (IDataCable)tile).isBlocked(dir.getOpposite())) {
                return true;
            }
        }
        return false;
    }
}

