/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.network.sync.SyncInt;
import sonar.core.network.sync.SyncString;
import sonar.core.network.utils.ITextField;
import sonar.core.utils.IMachineButtons;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.connecting.IDataConnection;
import sonar.logistics.api.connecting.IDataTile;
import sonar.logistics.common.blocks.BlockRedstoneSignaller;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.registries.BlockRegistry;

public class TileEntityRedstoneSignaller
extends TileEntitySonar
implements IDataTile,
IMachineButtons,
ITextField {
    public Info currentInfo;
    public SyncInt integerEmitType = new SyncInt(0);
    public SyncInt integerTarget = new SyncInt(1);
    public SyncInt dataType = new SyncInt(2);
    public SyncInt errorFlag = new SyncInt(3);
    public SyncString stringName = new SyncString(4);

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite() == dir;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.stringName.readFromNBT(nbt, type);
            this.integerEmitType.readFromNBT(nbt, type);
            this.integerTarget.readFromNBT(nbt, type);
            this.dataType.readFromNBT(nbt, type);
            this.errorFlag.readFromNBT(nbt, type);
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.stringName.writeToNBT(nbt, type);
            this.integerEmitType.writeToNBT(nbt, type);
            this.integerTarget.writeToNBT(nbt, type);
            this.dataType.writeToNBT(nbt, type);
            this.errorFlag.writeToNBT(nbt, type);
        }
    }

    public void func_145845_h() {
        if (this.isServer()) {
            Object object;
            boolean canEmit;
            BlockRedstoneSignaller block = (BlockRedstoneSignaller)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            boolean isOn = block == BlockRegistry.redstoneSignaller_on;
            if (isOn != (canEmit = this.canEmit())) {
                BlockRedstoneSignaller.updateSignallerState(canEmit, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if ((object = CableHelper.getConnectedTile((TileEntity)this, ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite())) != null) {
                if (object instanceof IDataConnection) {
                    IDataConnection infoNode = (IDataConnection)object;
                    this.currentInfo = infoNode.currentInfo();
                } else {
                    this.currentInfo = null;
                }
            } else {
                this.currentInfo = null;
            }
        }
    }

    public boolean maxRender() {
        return true;
    }

    public boolean canEmit() {
        if (this.currentInfo != null) {
            if (this.currentInfo.getDataType() == this.dataType.getInt()) {
                if (this.dataType.getInt() == 0) {
                    this.errorFlag.setInt(0);
                    int integer = Integer.parseInt(this.currentInfo.getData());
                    switch (this.integerEmitType.getInt()) {
                        case 0: {
                            return integer == this.integerTarget.getInt();
                        }
                        case 1: {
                            return integer > this.integerTarget.getInt();
                        }
                        case 2: {
                            return integer < this.integerTarget.getInt();
                        }
                        case 3: {
                            return integer != this.integerTarget.getInt();
                        }
                    }
                } else if (this.dataType.getInt() == 1) {
                    this.errorFlag.setInt(0);
                    return this.currentInfo.getData().equals(this.stringName.getString());
                }
            } else {
                this.errorFlag.setInt(2);
            }
        } else {
            this.errorFlag.setInt(1);
            return false;
        }
        return false;
    }

    public void buttonPress(int buttonID, int value) {
        switch (buttonID) {
            case 0: {
                this.dataType.setInt(value);
                break;
            }
            case 1: {
                this.integerEmitType.setInt(value);
            }
        }
    }

    public void textTyped(String string, int id) {
        if (id == 0) {
            if (string == null || string.isEmpty()) {
                this.integerTarget.setInt(0);
            } else {
                this.integerTarget.setInt(Integer.parseInt(string));
            }
        }
        if (id == 1) {
            if (string == null || string.isEmpty()) {
                this.stringName.setString("Unnamed Emitter");
            } else {
                this.stringName.setString(string);
            }
        }
    }
}

