/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.connecting.IMultiDataCable;
import sonar.logistics.helpers.CableHelper;

public class TileEntityMultiDataCable
extends TileEntitySonar
implements IMultiDataCable {
    public List<BlockCoords> coords;

    @Override
    public List<BlockCoords> getCoords() {
        return this.coords;
    }

    @Override
    public void addCoords(BlockCoords coords) {
        for (BlockCoords tile : this.coords) {
            if (!BlockCoords.equalCoords((BlockCoords)tile, (BlockCoords)coords)) continue;
            return;
        }
        this.coords.add(coords);
    }

    @Override
    public void removeCoords(BlockCoords coords) {
        ArrayList<BlockCoords> removed = new ArrayList<BlockCoords>();
        for (BlockCoords tile : this.coords) {
            if (!BlockCoords.equalCoords((BlockCoords)tile, (BlockCoords)coords)) continue;
            removed.add(tile);
        }
        for (BlockCoords remove : removed) {
            this.coords.remove(remove);
        }
    }

    @Override
    public boolean isBlocked(ForgeDirection dir) {
        return false;
    }

    @Override
    public boolean canRenderConnection(ForgeDirection dir) {
        return CableHelper.canRenderConnection((TileEntity)this, dir);
    }

    public boolean maxRender() {
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.coords = BlockCoords.readBlockCoords((NBTTagCompound)nbt, (String)"tiles");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            NBTTagCompound infoTag = new NBTTagCompound();
            BlockCoords.writeBlockCoords((NBTTagCompound)nbt, this.coords, (String)"tiles");
        }
    }

    public void func_145829_t() {
        this.coords = null;
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.coords = null;
        super.func_145843_s();
        CableHelper.updateAdjacentCoords(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, null, true);
    }
}

