/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.core.SonarCore;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.network.sync.SyncInt;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.utils.HammerRecipes;

public class TileEntityHammer
extends TileEntityInventory
implements ISidedInventory {
    public SyncInt progress = new SyncInt(0);
    public SyncInt coolDown = new SyncInt(1);
    public static int speed = 100;

    public TileEntityHammer() {
        this.slots = new ItemStack[2];
    }

    public void func_145845_h() {
        if (this.isClient()) {
            return;
        }
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        if (this.coolDown.getInt() != 0) {
            this.coolDown.increaseBy(-1);
            SonarCore.sendFullSyncAround((TileEntity)this, (int)64);
        } else if (this.canProcess()) {
            if (this.progress.getInt() < speed) {
                this.progress.increaseBy(1);
            } else {
                this.finishProcess();
                this.coolDown.setInt(speed * 2);
                this.progress.setInt(0);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            SonarCore.sendFullSyncAround((TileEntity)this, (int)64);
        } else {
            this.coolDown.setInt(this.progress.getInt() * 2);
            this.progress.setInt(0);
        }
    }

    public boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack[] output = HammerRecipes.instance().getOutput(new ItemStack[]{this.slots[0]});
        if (output == null || output.length != 1) {
            return false;
        }
        if (output[0] == null) {
            return false;
        }
        if (this.slots[1] != null) {
            if (!this.slots[1].func_77969_a(output[0])) {
                return false;
            }
            if (this.slots[1].field_77994_a + output[0].field_77994_a > this.slots[1].func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    public void finishProcess() {
        ItemStack[] output = HammerRecipes.instance().getOutput(new ItemStack[]{this.slots[0]});
        if (output != null && output[0] != null) {
            if (this.slots[1] == null) {
                this.slots[1] = output[0].func_77946_l();
            } else if (this.slots[1].func_77969_a(output[0])) {
                this.slots[1].field_77994_a += output[0].field_77994_a;
            }
            this.slots[0].field_77994_a -= HammerRecipes.instance().getInputSize(0, output);
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.progress.readFromNBT(nbt, type);
            this.coolDown.readFromNBT(nbt, type);
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.progress.writeToNBT(nbt, type);
            this.coolDown.writeToNBT(nbt, type);
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && HammerRecipes.instance().validInput(stack);
    }

    public boolean maxRender() {
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 1;
    }
}

