/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.network.sync.SyncInt;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.IMachineButtons;
import sonar.core.utils.helpers.NBTHelper;
import sonar.core.utils.helpers.SonarHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.connecting.IDataConnection;
import sonar.logistics.api.render.ICableRenderer;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.info.types.BlockCoordsInfo;

public class TileEntityEntityNode
extends TileEntitySonar
implements ICableRenderer,
IDataConnection,
IMachineButtons {
    public SyncInt entityTarget = new SyncInt(0);
    public float rotate = 0.0f;

    @Override
    public Info currentInfo() {
        return BlockCoordsInfo.createInfo("Entity Node", new BlockCoords((TileEntity)this));
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP;
    }

    @Override
    public boolean canRenderConnection(ForgeDirection dir) {
        if (dir == ForgeDirection.UP) {
            return false;
        }
        return CableHelper.canRenderConnection((TileEntity)this, dir);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.rotate = !(this.rotate >= 1.0f) ? (this.rotate += 0.01f) : 0.0f;
            return;
        }
        CableHelper.updateAdjacentCoords((TileEntity)this, new BlockCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e), false, new ForgeDirection[]{ForgeDirection.UP});
    }

    public boolean maxRender() {
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.entityTarget.readFromNBT(nbt, type);
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.entityTarget.writeToNBT(nbt, type);
        }
    }

    public void buttonPress(int buttonID, int value) {
        switch (buttonID) {
            case 0: {
                this.entityTarget.setInt(value);
            }
        }
    }

    public Entity getNearestEntity() {
        switch (this.entityTarget.getInt()) {
            case 1: {
                return SonarHelper.getNearestEntity(EntityPlayer.class, (TileEntity)this, (int)10);
            }
            case 2: {
                return SonarHelper.getNearestEntity(EntityMob.class, (TileEntity)this, (int)10);
            }
            case 3: {
                return SonarHelper.getNearestEntity(EntityAnimal.class, (TileEntity)this, (int)10);
            }
        }
        return SonarHelper.getNearestEntity(Entity.class, (TileEntity)this, (int)10);
    }
}

