/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.network.PacketTileSync;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.DataEmitter;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.connecting.IDataReceiver;
import sonar.logistics.common.tileentity.TileEntityDataEmitter;
import sonar.logistics.common.tileentity.TileEntityNode;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.network.SyncEmitter;
import sonar.logistics.registries.EmitterRegistry;

public class TileEntityDataReceiver
extends TileEntityNode
implements IDataReceiver {
    public List<DataEmitter> emitters;
    public List<DataEmitter> lastemitters;
    public SyncEmitter emitter = new SyncEmitter(0);

    @Override
    public DataEmitter getEmitter() {
        TileEntity tile;
        if (this.emitter.getEmitter() != null && (tile = this.emitter.getEmitter().coords.getTileEntity()) != null && tile instanceof TileEntityDataEmitter) {
            TileEntityDataEmitter dataEmitter = (TileEntityDataEmitter)tile;
            this.emitter.setEmitter(new DataEmitter(dataEmitter.clientName.getString(), this.emitter.getEmitter().coords));
        }
        return this.emitter.getEmitter();
    }

    @Override
    public Info currentInfo() {
        if (this.emitter.getEmitter() != null) {
            return new StandardInfo(-1, "DEFAULT", "Connected: ", (Object)this.emitter.getEmitter().coords.getRender());
        }
        return new StandardInfo(-1, "DEFAULT", "Connection: ", (Object)"NOT CONNECTED");
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return ForgeDirection.getOrientation((int)this.func_145832_p()) == dir;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isClient()) {
            return;
        }
        CableHelper.updateAdjacentCoord((TileEntity)this, new BlockCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e), false, ForgeDirection.getOrientation((int)this.func_145832_p()));
    }

    public boolean maxRender() {
        return true;
    }

    public void sendAvailableData(TileEntity te, EntityPlayer player) {
        if (player != null && player instanceof EntityPlayerMP) {
            this.emitters = EmitterRegistry.getEmitters(this.playerName);
            NBTTagCompound syncData = new NBTTagCompound();
            this.writeData(syncData, NBTHelper.SyncType.SPECIAL);
            SonarCore.network.sendTo((IMessage)new PacketTileSync(te.field_145851_c, te.field_145848_d, te.field_145849_e, syncData, NBTHelper.SyncType.SPECIAL), (EntityPlayerMP)player);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound compound;
        int i;
        NBTTagList list;
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.emitter.readFromNBT(nbt, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            this.emitter.readFromNBT(nbt, NBTHelper.SyncType.SYNC);
            if (nbt.func_74764_b("null")) {
                this.emitters = new ArrayList<DataEmitter>();
                return;
            }
            list = nbt.func_150295_c("Emitters", 10);
            if (this.emitters == null) {
                this.emitters = new ArrayList<DataEmitter>();
            }
            block5: for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                byte slot = compound.func_74771_c("Slot");
                boolean set = slot < this.emitters.size();
                switch (compound.func_74771_c("f")) {
                    case 0: {
                        if (set) {
                            this.emitters.set(slot, DataEmitter.readFromNBT(compound));
                            continue block5;
                        }
                        this.emitters.add(slot, DataEmitter.readFromNBT(compound));
                        continue block5;
                    }
                    case 1: {
                        String name = compound.func_74779_i("Name");
                        if (name != null) {
                            this.emitters.set(slot, new DataEmitter(name, this.emitters.get((int)slot).coords));
                            continue block5;
                        }
                        this.emitters.set(slot, null);
                        continue block5;
                    }
                    case 2: {
                        if (set) {
                            this.emitters.set(slot, null);
                            continue block5;
                        }
                        this.emitters.add(slot, null);
                    }
                }
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            this.emitter.readFromNBT(nbt, NBTHelper.SyncType.SAVE);
            list = nbt.func_150295_c("Emitters", 10);
            this.emitters = new ArrayList<DataEmitter>();
            for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                this.emitters.add(DataEmitter.readFromNBT(compound));
            }
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList list;
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.emitter.writeToNBT(nbt, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            this.emitter.writeToNBT(nbt, NBTHelper.SyncType.SYNC);
            if (this.emitters == null) {
                this.emitters = new ArrayList<DataEmitter>();
            }
            if (this.lastemitters == null) {
                this.lastemitters = new ArrayList<DataEmitter>();
            }
            if (this.emitters.size() <= 0 && this.lastemitters.size() > 0) {
                nbt.func_74757_a("null", true);
                this.lastemitters = new ArrayList<DataEmitter>();
                return;
            }
            list = new NBTTagList();
            int size = Math.max(this.emitters.size(), this.lastemitters.size());
            for (int i = 0; i < size; ++i) {
                DataEmitter current = null;
                DataEmitter last = null;
                if (i < this.emitters.size()) {
                    current = this.emitters.get(i);
                }
                if (i < this.lastemitters.size()) {
                    last = this.lastemitters.get(i);
                }
                NBTTagCompound compound = new NBTTagCompound();
                if (current != null) {
                    if (last != null) {
                        if (!BlockCoords.equalCoords((BlockCoords)current.coords, (BlockCoords)last.coords)) {
                            compound.func_74774_a("f", (byte)0);
                            this.lastemitters.set(i, current);
                            DataEmitter.writeToNBT(compound, this.emitters.get(i));
                        } else if (!current.name.equals(last.name)) {
                            compound.func_74774_a("f", (byte)1);
                            this.lastemitters.set(i, current);
                            compound.func_74778_a("Name", current.name);
                        }
                    } else {
                        compound.func_74774_a("f", (byte)0);
                        this.lastemitters.add(i, current);
                        DataEmitter.writeToNBT(compound, this.emitters.get(i));
                    }
                } else if (last != null) {
                    this.lastemitters.set(i, null);
                    compound.func_74774_a("f", (byte)2);
                }
                if (compound.func_82582_d()) continue;
                compound.func_74774_a("Slot", (byte)i);
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                nbt.func_74782_a("Emitters", (NBTBase)list);
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            this.emitter.writeToNBT(nbt, NBTHelper.SyncType.SAVE);
            list = new NBTTagList();
            if (this.emitters == null) {
                this.emitters = new ArrayList<DataEmitter>();
            }
            for (int i = 0; i < this.emitters.size(); ++i) {
                if (this.emitters.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74774_a("Slot", (byte)i);
                DataEmitter.writeToNBT(compound, this.emitters.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a("Emitters", (NBTBase)list);
        }
    }
}

