/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.network.sync.SyncString;
import sonar.core.network.utils.ITextField;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.connecting.IDataConnection;
import sonar.logistics.common.tileentity.TileEntityNode;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.info.types.BlockCoordsInfo;
import sonar.logistics.registries.EmitterRegistry;

public class TileEntityDataEmitter
extends TileEntityNode
implements IDataConnection,
ITextField {
    public SyncString clientName = new SyncString(0, "Unnamed Emitter");

    public Object getConnectedTile() {
        return CableHelper.getConnectedTile((TileEntity)this, ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite());
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.clientName.readFromNBT(nbt, type);
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.clientName.writeToNBT(nbt, type);
        }
    }

    public void addToFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            EmitterRegistry.addEmitters(this.playerName, new BlockCoords((TileEntity)this, this.field_145850_b.field_73011_w.field_76574_g));
        }
    }

    public void removeFromFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            EmitterRegistry.removeEmitter(this.playerName, new BlockCoords((TileEntity)this, this.field_145850_b.field_73011_w.field_76574_g));
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            this.removeFromFrequency();
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.addToFrequency();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.removeFromFrequency();
        }
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir == ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
    }

    @Override
    public Info currentInfo() {
        return BlockCoordsInfo.createInfo("Data Emitter", new BlockCoords((TileEntity)this));
    }

    public boolean maxRender() {
        return true;
    }

    public void textTyped(String string, int id) {
        if (id == 0) {
            if (string == null || string.isEmpty()) {
                this.clientName.setString("Unnamed Emitter");
            } else {
                this.clientName.setString(string);
            }
        }
    }
}

