/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.helpers.CableHelper;

public class TileEntityDataCable
extends TileEntitySonar
implements IDataCable {
    public BlockCoords coords;

    @Override
    public BlockCoords getCoords() {
        return this.coords;
    }

    @Override
    public void setCoords(BlockCoords coords) {
        if (!BlockCoords.equalCoords((BlockCoords)this.coords, (BlockCoords)coords)) {
            this.coords = coords;
            CableHelper.updateAdjacentCoords((TileEntity)this, coords, true);
        }
    }

    @Override
    public boolean isBlocked(ForgeDirection dir) {
        return false;
    }

    @Override
    public boolean canRenderConnection(ForgeDirection dir) {
        return CableHelper.canRenderConnection((TileEntity)this, dir);
    }

    public boolean maxRender() {
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b("coords")) {
            this.coords = nbt.func_74775_l("coords").func_74767_n("hasCoords") ? BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("coords")) : null;
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            NBTTagCompound infoTag = new NBTTagCompound();
            if (this.coords != null) {
                BlockCoords.writeToNBT((NBTTagCompound)infoTag, (BlockCoords)this.coords);
                infoTag.func_74757_a("hasCoords", true);
            } else {
                infoTag.func_74757_a("hasCoords", false);
            }
            nbt.func_74782_a("coords", (NBTBase)infoTag);
        }
    }

    public void func_145829_t() {
        this.coords = null;
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.coords = null;
        super.func_145843_s();
        CableHelper.updateAdjacentCoords(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, null, true);
    }
}

