/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.network.sync.SyncBoolean;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.connecting.ILargeDisplay;
import sonar.logistics.api.render.LargeScreenSizing;
import sonar.logistics.common.handlers.DisplayScreenHandler;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.DisplayHelper;

public class LargeDisplayScreenHandler
extends DisplayScreenHandler
implements ILargeDisplay,
IByteBufTile {
    public SyncBoolean isHandler = new SyncBoolean(0);
    public List<BlockCoords> displays = new ArrayList<BlockCoords>();
    public BlockCoords handler = null;
    public LargeScreenSizing sizing;
    public boolean resetSizing = true;
    public BlockCoords connectedTile = null;

    public LargeDisplayScreenHandler(boolean isMultipart) {
        super(isMultipart);
    }

    @Override
    public void update(TileEntity te) {
        if (!te.func_145831_w().field_72995_K) {
            if (!this.isHandler.getBoolean()) {
                return;
            }
            if (this.resetSizing) {
                this.sizing = DisplayHelper.getScreenSizing(te);
                SonarCore.sendPacketAround((TileEntity)te, (int)64, (int)2);
                this.resetSizing = false;
            }
            this.connectedTile = this.getConnectedTile(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
            if (this.connectedTile == null || this.connectedTile.getTileEntity(te.func_145831_w()) == null) {
                this.updateData(te, te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
            } else {
                this.updateData(this.connectedTile.getTileEntity(te.func_145831_w()), te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
            }
        }
    }

    public BlockCoords getConnectedTile(TileEntity te, ForgeDirection dir) {
        if (this.displays != null) {
            for (BlockCoords coords : this.displays) {
                TileEntity target = coords.getTileEntity(te.func_145831_w());
                Object connectedTile = CableHelper.getConnectedTile(target, dir.getOpposite());
                if ((connectedTile = FMPHelper.checkObject((Object)connectedTile)) == null) continue;
                return coords;
            }
        }
        return null;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        if (id == 2) {
            if (this.sizing != null) {
                buf.writeBoolean(true);
                this.sizing.writeToBuf(buf);
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        if (id == 2) {
            this.sizing = buf.readBoolean() ? LargeScreenSizing.readFromBuf(buf) : null;
        }
    }

    @Override
    public boolean isHandler() {
        return this.isHandler.getBoolean();
    }

    @Override
    public List<BlockCoords> getConnectedScreens() {
        if (this.displays == null) {
            return Collections.EMPTY_LIST;
        }
        return this.displays;
    }

    @Override
    public BlockCoords getHandlerCoords() {
        return this.handler;
    }

    @Override
    public void setHandlerCoords(BlockCoords coords) {
        this.handler = coords;
    }

    @Override
    public void setHandler(boolean isHandler) {
        this.isHandler.setBoolean(isHandler);
    }

    @Override
    public void addDisplay(BlockCoords coords) {
        if (this.displays == null) {
            this.displays = new ArrayList<BlockCoords>();
        }
        this.displays.add(coords);
        this.resetSizing();
    }

    @Override
    public void removeDisplay(BlockCoords coords) {
        for (BlockCoords display : this.displays) {
            if (!BlockCoords.equalCoords((BlockCoords)display, (BlockCoords)coords)) continue;
            this.displays.remove(display);
            this.resetSizing();
            return;
        }
    }

    @Override
    public void setConnectedScreens(List<BlockCoords> list) {
        this.displays = list == null ? new ArrayList<BlockCoords>() : list;
    }

    @Override
    public void resetSizing() {
        this.resetSizing = true;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.isHandler.readFromNBT(nbt, type);
            if (nbt.func_74764_b("hCoords")) {
                this.handler = BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("hCoords"));
            }
            if (nbt.func_74764_b("cCoords")) {
                this.connectedTile = BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("cCoords"));
            }
            if (nbt.func_74764_b("mxY")) {
                this.sizing = LargeScreenSizing.readFromNBT(nbt);
            }
            if (this.displays == null) {
                this.displays = new ArrayList<BlockCoords>();
            }
            NBTTagList list = nbt.func_150295_c("BlockCoords", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                this.displays.add(BlockCoords.readFromNBT((NBTTagCompound)compound));
            }
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            NBTTagCompound infoTag;
            this.isHandler.writeToNBT(nbt, type);
            if (this.handler != null) {
                infoTag = new NBTTagCompound();
                BlockCoords.writeToNBT((NBTTagCompound)infoTag, (BlockCoords)this.handler);
                nbt.func_74782_a("hCoords", (NBTBase)infoTag);
            }
            if (this.connectedTile != null) {
                infoTag = new NBTTagCompound();
                BlockCoords.writeToNBT((NBTTagCompound)infoTag, (BlockCoords)this.connectedTile);
                nbt.func_74782_a("cCoords", (NBTBase)infoTag);
            }
            if (this.sizing != null) {
                this.sizing.writeToNBT(nbt);
            }
            NBTTagList list = new NBTTagList();
            if (this.displays != null) {
                for (int i = 0; i < this.displays.size(); ++i) {
                    if (this.displays.get(i) == null) continue;
                    NBTTagCompound compound = new NBTTagCompound();
                    BlockCoords.writeToNBT((NBTTagCompound)compound, (BlockCoords)this.displays.get(i));
                    list.func_74742_a((NBTBase)compound);
                }
            }
            nbt.func_74782_a("BlockCoords", (NBTBase)list);
        }
    }
}

