/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.InventoryTileHandler;
import sonar.core.inventory.StoredItemStack;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.common.tileentity.TileEntityBlockNode;
import sonar.logistics.common.tileentity.TileEntityEntityNode;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.info.types.StoredStackInfo;

public class InventoryReaderHandler
extends InventoryTileHandler {
    public BlockCoords coords;
    public List<StoredItemStack> stacks;
    public List<StoredItemStack> lastStacks;
    public ItemStack current;

    public InventoryReaderHandler(boolean isMultipart) {
        super(isMultipart);
        this.slots = new ItemStack[1];
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        this.updateData(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
    }

    public void updateData(TileEntity te, ForgeDirection dir) {
        Object target = CableHelper.getConnectedTile(te, dir.getOpposite());
        if ((target = FMPHelper.checkObject((Object)target)) == null) {
            this.setCoords(null);
        } else if (target instanceof TileEntityBlockNode || target instanceof TileEntityEntityNode) {
            TileEntity node = (TileEntity)target;
            this.setCoords(new BlockCoords(node, node.func_145831_w().field_73011_w.field_76574_g));
        } else {
            this.setCoords(null);
        }
        if (this.coords != null) {
            TileEntity tile = this.coords.getTileEntity();
            if (tile != null && tile instanceof TileEntityBlockNode) {
                TileEntityBlockNode node = (TileEntityBlockNode)target;
                this.stacks = InfoHelper.getTileInventory(node);
                CableHelper.updateAdjacentCoord(te, new BlockCoords(te.field_145851_c, te.field_145848_d, te.field_145849_e), false, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
            } else if (tile != null && tile instanceof TileEntityEntityNode) {
                TileEntityEntityNode node = (TileEntityEntityNode)target;
                this.stacks = InfoHelper.getEntityInventory(node);
                CableHelper.updateAdjacentCoord(te, new BlockCoords(te.field_145851_c, te.field_145848_d, te.field_145849_e), false, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
            } else {
                this.stacks = null;
            }
        } else {
            this.stacks = null;
        }
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te))) || dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    public void setCoords(BlockCoords coords) {
        if (!BlockCoords.equalCoords((BlockCoords)this.coords, (BlockCoords)coords)) {
            this.coords = coords;
        }
    }

    public Info currentInfo(TileEntity te) {
        if (this.slots[0] != null) {
            if (this.stacks != null) {
                for (StoredItemStack stack : this.stacks) {
                    if (!stack.equalStack(this.slots[0])) continue;
                    return StoredStackInfo.createInfo(stack);
                }
            }
            return StoredStackInfo.createInfo(new StoredItemStack(this.slots[0], 0L));
        }
        return new StandardInfo(-1, "ITEMREND", " ", (Object)"NO DATA");
    }

    public void removed(World world, int x, int y, int z, int meta) {
        IDataCable cable;
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        Object tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if ((tile = FMPHelper.checkObject((Object)tile)) != null && tile instanceof IDataCable && (cable = (IDataCable)tile).getCoords() != null) {
            cable.setCoords(null);
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound compound;
        int i;
        NBTTagList list;
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b("coords")) {
            this.coords = nbt.func_74775_l("coords").func_74767_n("hasCoords") ? BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("coords")) : null;
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (nbt.func_74764_b("null")) {
                this.stacks = new ArrayList<StoredItemStack>();
                return;
            }
            list = nbt.func_150295_c("Stacks", 10);
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredItemStack>();
            }
            block5: for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                int slot = compound.func_74762_e("Slot");
                boolean set = slot < this.stacks.size();
                switch (compound.func_74771_c("f")) {
                    case 0: {
                        if (set) {
                            this.stacks.set(slot, StoredItemStack.readFromNBT((NBTTagCompound)compound));
                            continue block5;
                        }
                        this.stacks.add(slot, StoredItemStack.readFromNBT((NBTTagCompound)compound));
                        continue block5;
                    }
                    case 1: {
                        long stored = compound.func_74763_f("Stored");
                        if (stored != 0L) {
                            this.stacks.set(slot, new StoredItemStack(this.stacks.get((int)slot).item, stored));
                            continue block5;
                        }
                        this.stacks.set(slot, null);
                        continue block5;
                    }
                    case 2: {
                        if (set) {
                            this.stacks.set(slot, null);
                            continue block5;
                        }
                        this.stacks.add(slot, null);
                    }
                }
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            list = nbt.func_150295_c("StoredStacks", 10);
            this.stacks = new ArrayList<StoredItemStack>();
            for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                this.stacks.add(StoredItemStack.readFromNBT((NBTTagCompound)compound));
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList list;
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            NBTTagCompound coordTag = new NBTTagCompound();
            if (this.coords != null) {
                BlockCoords.writeToNBT((NBTTagCompound)coordTag, (BlockCoords)this.coords);
                coordTag.func_74757_a("hasCoords", true);
            } else {
                coordTag.func_74757_a("hasCoords", false);
            }
            nbt.func_74782_a("coords", (NBTBase)coordTag);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredItemStack>();
            }
            if (this.lastStacks == null) {
                this.lastStacks = new ArrayList<StoredItemStack>();
            }
            if (this.stacks.size() <= 0 && this.lastStacks.size() > 0) {
                nbt.func_74757_a("null", true);
                this.lastStacks = new ArrayList<StoredItemStack>();
                return;
            }
            list = new NBTTagList();
            int size = Math.max(this.stacks.size(), this.lastStacks.size());
            for (int i = 0; i < size; ++i) {
                StoredItemStack current = null;
                StoredItemStack last = null;
                if (i < this.stacks.size()) {
                    current = this.stacks.get(i);
                }
                if (i < this.lastStacks.size()) {
                    last = this.lastStacks.get(i);
                }
                NBTTagCompound compound = new NBTTagCompound();
                if (current != null) {
                    if (last != null) {
                        if (!ItemStack.func_77989_b((ItemStack)last.item, (ItemStack)current.item)) {
                            compound.func_74774_a("f", (byte)0);
                            this.lastStacks.set(i, current);
                            StoredItemStack.writeToNBT((NBTTagCompound)compound, (StoredItemStack)this.stacks.get(i));
                        } else if (last.stored != current.stored) {
                            compound.func_74774_a("f", (byte)1);
                            this.lastStacks.set(i, current);
                            StoredItemStack.writeToNBT((NBTTagCompound)compound, (StoredItemStack)this.stacks.get(i));
                            compound.func_74772_a("Stored", current.stored);
                        }
                    } else {
                        compound.func_74774_a("f", (byte)0);
                        this.lastStacks.add(i, current);
                        StoredItemStack.writeToNBT((NBTTagCompound)compound, (StoredItemStack)this.stacks.get(i));
                    }
                } else if (last != null) {
                    this.lastStacks.set(i, null);
                    compound.func_74774_a("f", (byte)2);
                }
                if (compound.func_82582_d()) continue;
                compound.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                nbt.func_74782_a("Stacks", (NBTBase)list);
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            list = new NBTTagList();
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredItemStack>();
            }
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (this.stacks.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                StoredItemStack.writeToNBT((NBTTagCompound)compound, (StoredItemStack)this.stacks.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a("StoredStacks", (NBTBase)list);
        }
    }
}

