/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.integration.IWailaInfo;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketTileSync;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.common.tileentity.TileEntityBlockNode;
import sonar.logistics.common.tileentity.TileEntityEntityNode;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.info.types.CategoryInfo;
import sonar.logistics.network.SyncInfo;

public class InfoReaderHandler
extends TileHandler
implements IWailaInfo {
    public List<Info> clientInfo;
    public List<Info> lastInfo;
    public SyncInfo primaryInfo = new SyncInfo(0);
    public SyncInfo secondaryInfo = new SyncInfo(1);
    public BlockCoords coords;

    public InfoReaderHandler(boolean isMultipart) {
        super(isMultipart);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        this.updateData(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
    }

    public void updateData(TileEntity te, ForgeDirection dir) {
        Object target = CableHelper.getConnectedTile(te, dir.getOpposite());
        if ((target = FMPHelper.checkObject((Object)target)) == null) {
            this.setCoords(null);
        } else if (target instanceof TileEntityBlockNode || target instanceof TileEntityEntityNode) {
            TileEntity node = (TileEntity)target;
            this.setCoords(new BlockCoords(node, node.func_145831_w().field_73011_w.field_76574_g));
        } else {
            this.setCoords(null);
        }
        if (this.primaryInfo.getInfo() != null) {
            if (this.coords != null) {
                TileEntity tile = this.coords.getTileEntity();
                if (tile != null && tile instanceof TileEntityBlockNode) {
                    this.setData(te, InfoHelper.getLatestTileInfo(this.primaryInfo.getInfo(), (TileEntityBlockNode)tile), true);
                    this.setData(te, InfoHelper.getLatestTileInfo(this.secondaryInfo.getInfo(), (TileEntityBlockNode)tile), false);
                } else if (tile != null && tile instanceof TileEntityEntityNode) {
                    this.setData(te, InfoHelper.getLatestEntityInfo(this.primaryInfo.getInfo(), (TileEntityEntityNode)tile), true);
                    this.setData(te, InfoHelper.getLatestEntityInfo(this.secondaryInfo.getInfo(), (TileEntityEntityNode)tile), false);
                } else {
                    this.setData(te, null, true);
                    this.setData(te, null, false);
                }
            } else {
                this.setData(te, null, true);
                this.setData(te, null, false);
            }
        }
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te))) || dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    public void setCoords(BlockCoords coords) {
        if (!BlockCoords.equalCoords((BlockCoords)this.coords, (BlockCoords)coords)) {
            this.coords = coords;
        }
    }

    public Info currentInfo(TileEntity te) {
        if (this.secondaryInfo.getInfo() == null || !te.func_145831_w().func_72864_z(te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
            if (this.primaryInfo.getInfo() == null) {
                return new StandardInfo(-1, "", "", (Object)"NO DATA");
            }
            return this.primaryInfo.getInfo();
        }
        if (this.secondaryInfo.getInfo() == null) {
            return new StandardInfo(-1, "", "", (Object)"NO DATA");
        }
        return this.secondaryInfo.getInfo();
    }

    public Info getSecondaryInfo(TileEntity te) {
        if (this.primaryInfo.getInfo() == null || !te.func_145831_w().func_72864_z(te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
            if (this.secondaryInfo.getInfo() == null) {
                return new StandardInfo(-1, "", "", (Object)"NO DATA");
            }
            return this.secondaryInfo.getInfo();
        }
        if (this.primaryInfo.getInfo() == null) {
            return new StandardInfo(-1, "", "", (Object)"NO DATA");
        }
        return this.primaryInfo.getInfo();
    }

    public void setData(TileEntity te, Info info, boolean primary) {
        if (info != null) {
            if (primary) {
                this.primaryInfo.setInfo(info);
            } else {
                this.secondaryInfo.setInfo(info);
            }
        } else if (primary && this.primaryInfo.getInfo() != null) {
            this.primaryInfo.getInfo().emptyData();
        } else if (!primary && this.secondaryInfo.getInfo() != null) {
            this.secondaryInfo.getInfo().emptyData();
        }
        CableHelper.updateAdjacentCoord(te, new BlockCoords(te.field_145851_c, te.field_145848_d, te.field_145849_e), false, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
    }

    public void removed(World world, int x, int y, int z, int meta) {
        IDataCable cable;
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        Object tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if ((tile = FMPHelper.checkObject((Object)tile)) != null && tile instanceof IDataCable && (cable = (IDataCable)tile).getCoords() != null) {
            cable.setCoords(null);
        }
    }

    public void sendAvailableData(TileEntity te, EntityPlayer player) {
        if (player != null && player instanceof EntityPlayerMP && this.coords != null) {
            this.lastInfo = this.clientInfo;
            TileEntity tile = this.coords.getTileEntity();
            List<Object> info = new ArrayList();
            info = tile != null && tile instanceof TileEntityBlockNode ? InfoHelper.getTileInfo((TileEntityBlockNode)tile) : (tile != null && tile instanceof TileEntityEntityNode ? InfoHelper.getEntityInfo((TileEntityEntityNode)tile) : new ArrayList());
            ArrayList<Info> newInfo = new ArrayList<Info>();
            Info lastInfo = null;
            for (Info info2 : info) {
                if (lastInfo == null || !lastInfo.getCategory().equals(info2.getCategory())) {
                    newInfo.add(CategoryInfo.createInfo(info2.getCategory()));
                }
                newInfo.add(info2);
                lastInfo = info2;
            }
            this.clientInfo = newInfo;
            NBTTagCompound tag = new NBTTagCompound();
            this.writeData(tag, NBTHelper.SyncType.SPECIAL);
            if (!tag.func_82582_d()) {
                SonarCore.network.sendTo((IMessage)new PacketTileSync(te.field_145851_c, te.field_145848_d, te.field_145849_e, tag, NBTHelper.SyncType.SPECIAL), (EntityPlayerMP)player);
            }
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.primaryInfo.readFromNBT(nbt, type);
            this.secondaryInfo.readFromNBT(nbt, type);
            if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b("coords")) {
                this.coords = nbt.func_74775_l("coords").func_74767_n("hasCoords") ? BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("coords")) : null;
            }
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (nbt.func_74764_b("null")) {
                this.clientInfo = new ArrayList<Info>();
                return;
            }
            NBTTagList list = nbt.func_150295_c("Info", 10);
            if (this.clientInfo == null) {
                this.clientInfo = new ArrayList<Info>();
            }
            block5: for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                int slot = compound.func_74762_e("Slot");
                boolean set = slot < this.clientInfo.size();
                switch (compound.func_74771_c("f")) {
                    case 0: {
                        if (set) {
                            this.clientInfo.set(slot, InfoHelper.readInfo(compound));
                            continue block5;
                        }
                        this.clientInfo.add(slot, InfoHelper.readInfo(compound));
                        continue block5;
                    }
                    case 1: {
                        long stored = compound.func_74763_f("Stored");
                        if (stored != 0L) {
                            this.clientInfo.set(slot, InfoHelper.readInfo(compound));
                            continue block5;
                        }
                        this.clientInfo.set(slot, null);
                        continue block5;
                    }
                    case 2: {
                        this.clientInfo.set(slot, null);
                    }
                }
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.primaryInfo.writeToNBT(nbt, type);
            this.secondaryInfo.writeToNBT(nbt, type);
            if (type == NBTHelper.SyncType.SAVE) {
                NBTTagCompound coordTag = new NBTTagCompound();
                if (this.coords != null) {
                    BlockCoords.writeToNBT((NBTTagCompound)coordTag, (BlockCoords)this.coords);
                    coordTag.func_74757_a("hasCoords", true);
                } else {
                    coordTag.func_74757_a("hasCoords", false);
                }
                nbt.func_74782_a("coords", (NBTBase)coordTag);
            }
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (this.clientInfo == null) {
                this.clientInfo = new ArrayList<Info>();
            }
            if (this.lastInfo == null) {
                this.lastInfo = new ArrayList<Info>();
            }
            if (this.clientInfo.size() <= 0 && this.lastInfo.size() > 0) {
                nbt.func_74757_a("null", true);
                this.lastInfo = new ArrayList<Info>();
                return;
            }
            NBTTagList list = new NBTTagList();
            int size = Math.max(this.clientInfo.size(), this.lastInfo.size());
            for (int i = 0; i < size; ++i) {
                Info current = null;
                Info last = null;
                if (i < this.clientInfo.size()) {
                    current = this.clientInfo.get(i);
                }
                if (i < this.lastInfo.size()) {
                    last = this.lastInfo.get(i);
                }
                NBTTagCompound compound = new NBTTagCompound();
                if (current != null) {
                    if (last != null) {
                        if (!current.isEqualType(last) || !current.isDataEqualType(last)) {
                            compound.func_74774_a("f", (byte)0);
                            this.lastInfo.set(i, current);
                            InfoHelper.writeInfo(compound, this.clientInfo.get(i));
                        } else if (!current.isDataEqualType(last)) {
                            // empty if block
                        }
                    } else {
                        compound.func_74774_a("f", (byte)0);
                        this.lastInfo.add(i, current);
                        InfoHelper.writeInfo(compound, this.clientInfo.get(i));
                    }
                } else if (last != null) {
                    this.lastInfo.set(i, null);
                    compound.func_74774_a("f", (byte)2);
                }
                if (compound.func_82582_d()) continue;
                compound.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                nbt.func_74782_a("Info", (NBTBase)list);
            }
        }
    }

    public List<String> getWailaInfo(List<String> currenttip) {
        currenttip.add("TESTING WAILA!");
        return currenttip;
    }
}

