/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.sync.SyncString;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.InfoHelper;

public class InfoCreatorHandler
extends TileHandler {
    public SyncString subCategory = new SyncString(0);
    public SyncString data = new SyncString(1);
    public Info info;

    public InfoCreatorHandler(boolean isMultipart) {
        super(isMultipart);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        CableHelper.updateAdjacentCoord(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, new BlockCoords(te.field_145851_c, te.field_145848_d, te.field_145849_e), false, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.subCategory.readFromNBT(nbt, type);
            this.data.readFromNBT(nbt, type);
            if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b("currentInfo")) {
                this.info = InfoHelper.readInfo(nbt.func_74775_l("currentInfo"));
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.subCategory.writeToNBT(nbt, type);
            this.data.writeToNBT(nbt, type);
            if (type == NBTHelper.SyncType.SAVE && this.info != null) {
                NBTTagCompound infoTag = new NBTTagCompound();
                InfoHelper.writeInfo(infoTag, this.info);
                nbt.func_74782_a("currentInfo", (NBTBase)infoTag);
            }
        }
    }

    public boolean canRenderConnection(TileEntity te, ForgeDirection dir) {
        if (dir == ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te))) {
            return CableHelper.canRenderConnection(te, dir);
        }
        return false;
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir == ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te));
    }

    public Info currentInfo() {
        return this.info;
    }

    public void textTyped(String string, int id) {
        String text = string == null || string.isEmpty() ? " " : string;
        switch (id) {
            case 0: {
                this.subCategory.setString(string);
                break;
            }
            case 1: {
                this.data.setString(string);
            }
        }
        this.info = new StandardInfo(-1, "CREATOR", this.subCategory.getString(), (Object)this.data.getString());
    }

    public void removed(World world, int x, int y, int z, int meta) {
        CableHelper.updateAdjacentCoords(world, x, y, z, null, true);
    }
}

