/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.fluid.StoredFluidStack;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.common.tileentity.TileEntityBlockNode;
import sonar.logistics.common.tileentity.TileEntityEntityNode;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.FluidHelper;
import sonar.logistics.info.types.FluidStackInfo;

public class FluidReaderHandler
extends TileHandler {
    public BlockCoords coords;
    public List<StoredFluidStack> stacks;
    public List<StoredFluidStack> lastStacks;
    public FluidStack current;

    public FluidReaderHandler(boolean isMultipart) {
        super(isMultipart);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        this.updateData(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
    }

    public void updateData(TileEntity te, ForgeDirection dir) {
        Object target = CableHelper.getConnectedTile(te, dir.getOpposite());
        if ((target = FMPHelper.checkObject((Object)target)) == null) {
            this.setCoords(null);
        } else if (target instanceof TileEntityBlockNode || target instanceof TileEntityEntityNode) {
            TileEntity node = (TileEntity)target;
            this.setCoords(new BlockCoords(node, node.func_145831_w().field_73011_w.field_76574_g));
        } else {
            this.setCoords(null);
        }
        if (this.coords != null) {
            TileEntity tile = this.coords.getTileEntity();
            if (tile != null && tile instanceof TileEntityBlockNode) {
                TileEntityBlockNode node = (TileEntityBlockNode)target;
                this.stacks = FluidHelper.getFluids(node);
                CableHelper.updateAdjacentCoord(te, new BlockCoords(te.field_145851_c, te.field_145848_d, te.field_145849_e), false, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
            } else {
                this.stacks = null;
            }
        } else {
            this.stacks = null;
        }
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te))) || dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    public void setCoords(BlockCoords coords) {
        if (!BlockCoords.equalCoords((BlockCoords)this.coords, (BlockCoords)coords)) {
            this.coords = coords;
        }
    }

    public Info currentInfo(TileEntity te) {
        if (this.current != null && this.current.getFluid() != null) {
            if (this.stacks != null) {
                for (StoredFluidStack stack : this.stacks) {
                    if (stack == null || !stack.fluid.isFluidEqual(this.current)) continue;
                    return FluidStackInfo.createInfo(stack);
                }
            }
            return FluidStackInfo.createInfo(new StoredFluidStack(this.current, 0L, 0L));
        }
        return new StandardInfo(-1, "ITEMREND", " ", (Object)"NO DATA");
    }

    public void removed(World world, int x, int y, int z, int meta) {
        IDataCable cable;
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        Object tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if ((tile = FMPHelper.checkObject((Object)tile)) != null && tile instanceof IDataCable && (cable = (IDataCable)tile).getCoords() != null) {
            cable.setCoords(null);
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound compound;
        int i;
        NBTTagList list;
        super.readData(nbt, type);
        if (nbt.func_74764_b("FluidName")) {
            this.current = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        }
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b("coords")) {
            this.coords = nbt.func_74775_l("coords").func_74767_n("hasCoords") ? BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("coords")) : null;
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (nbt.func_74764_b("null")) {
                this.stacks = new ArrayList<StoredFluidStack>();
                return;
            }
            list = nbt.func_150295_c("Stacks", 10);
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredFluidStack>();
            }
            block4: for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                int slot = compound.func_74762_e("Slot");
                boolean set = slot < this.stacks.size();
                switch (compound.func_74771_c("f")) {
                    case 0: {
                        if (set) {
                            this.stacks.set(slot, StoredFluidStack.readFromNBT((NBTTagCompound)compound));
                            continue block4;
                        }
                        this.stacks.add(slot, StoredFluidStack.readFromNBT((NBTTagCompound)compound));
                        continue block4;
                    }
                    case 2: {
                        if (set) {
                            this.stacks.set(slot, null);
                            continue block4;
                        }
                        this.stacks.add(slot, null);
                    }
                }
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            list = nbt.func_150295_c("StoredStacks", 10);
            this.stacks = new ArrayList<StoredFluidStack>();
            for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                this.stacks.add(StoredFluidStack.readFromNBT((NBTTagCompound)compound));
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList list;
        super.writeData(nbt, type);
        if (this.current != null) {
            this.current.writeToNBT(nbt);
        }
        if (type == NBTHelper.SyncType.SAVE) {
            NBTTagCompound coordTag = new NBTTagCompound();
            if (this.coords != null) {
                BlockCoords.writeToNBT((NBTTagCompound)coordTag, (BlockCoords)this.coords);
                coordTag.func_74757_a("hasCoords", true);
            } else {
                coordTag.func_74757_a("hasCoords", false);
            }
            nbt.func_74782_a("coords", (NBTBase)coordTag);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredFluidStack>();
            }
            if (this.lastStacks == null) {
                this.lastStacks = new ArrayList<StoredFluidStack>();
            }
            if (this.stacks.size() <= 0 && this.lastStacks.size() > 0) {
                nbt.func_74757_a("null", true);
                this.lastStacks = new ArrayList<StoredFluidStack>();
                return;
            }
            list = new NBTTagList();
            int size = Math.max(this.stacks.size(), this.lastStacks.size());
            for (int i = 0; i < size; ++i) {
                StoredFluidStack current = null;
                StoredFluidStack last = null;
                if (i < this.stacks.size()) {
                    current = this.stacks.get(i);
                }
                if (i < this.lastStacks.size()) {
                    last = this.lastStacks.get(i);
                }
                NBTTagCompound compound = new NBTTagCompound();
                if (current != null) {
                    if (last != null) {
                        if (!last.equalStack(current.fluid) || current.stored != last.stored) {
                            compound.func_74774_a("f", (byte)0);
                            this.lastStacks.set(i, current);
                            StoredFluidStack.writeToNBT((NBTTagCompound)compound, (StoredFluidStack)this.stacks.get(i));
                        }
                    } else {
                        compound.func_74774_a("f", (byte)0);
                        this.lastStacks.add(i, current);
                        StoredFluidStack.writeToNBT((NBTTagCompound)compound, (StoredFluidStack)this.stacks.get(i));
                    }
                } else if (last != null) {
                    this.lastStacks.set(i, null);
                    compound.func_74774_a("f", (byte)2);
                }
                if (compound.func_82582_d()) continue;
                compound.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                nbt.func_74782_a("Stacks", (NBTBase)list);
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            list = new NBTTagList();
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredFluidStack>();
            }
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (this.stacks.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                StoredFluidStack.writeToNBT((NBTTagCompound)compound, (StoredFluidStack)this.stacks.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a("StoredStacks", (NBTBase)list);
        }
    }
}

