/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.connecting.IDataConnection;
import sonar.logistics.api.connecting.IInfoReader;
import sonar.logistics.common.tileentity.TileEntityInventoryReader;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.InfoHelper;

public class DisplayScreenHandler
extends TileHandler
implements IByteBufTile {
    public Info info;

    public DisplayScreenHandler(boolean isMultipart) {
        super(isMultipart);
    }

    public void update(TileEntity te) {
        if (!te.func_145831_w().field_72995_K) {
            this.updateData(te, te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
        }
    }

    public void updateData(TileEntity te, TileEntity packetTile, ForgeDirection dir) {
        Object target = CableHelper.getConnectedTile(te, dir.getOpposite());
        if ((target = FMPHelper.checkObject((Object)target)) == null) {
            return;
        }
        Info lastInfo = this.info;
        if (target instanceof IInfoReader) {
            IInfoReader infoReader = (IInfoReader)target;
            if (infoReader.currentInfo() != null && infoReader.getSecondaryInfo() != null) {
                this.info = InfoHelper.combineData(infoReader.currentInfo(), infoReader.getSecondaryInfo());
            } else if (infoReader.currentInfo() != null) {
                this.info = infoReader.currentInfo();
            } else if (this.info != null) {
                this.info.emptyData();
            }
        } else if (target instanceof TileEntityInventoryReader) {
            TileEntityInventoryReader infoNode = (TileEntityInventoryReader)target;
            if (infoNode.currentInfo() != null) {
                this.info = infoNode.currentInfo();
            } else if (this.info != null) {
                this.info.emptyData();
            }
        } else if (target instanceof IDataConnection) {
            IDataConnection infoNode = (IDataConnection)target;
            if (infoNode.currentInfo() != null) {
                this.info = infoNode.currentInfo();
            } else if (this.info != null) {
                this.info.emptyData();
            }
        }
        if (this.info != null) {
            if (!this.info.isEqualType(lastInfo) || !this.info.isDataEqualType(lastInfo)) {
                if (this.info instanceof StandardInfo && this.info.isEqualType(lastInfo)) {
                    SonarCore.sendPacketAround((TileEntity)packetTile, (int)64, (int)0);
                } else {
                    SonarCore.sendPacketAround((TileEntity)packetTile, (int)64, (int)0);
                }
            }
        } else {
            SonarCore.sendPacketAround((TileEntity)packetTile, (int)64, (int)0);
        }
    }

    public Info currentInfo() {
        return this.info;
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        if (this.info != null) {
            currenttip.add("Current Data: " + this.info.getDisplayableData());
        }
        return currenttip;
    }

    public void removed(World world, int x, int y, int z, int meta) {
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 0) {
            if (this.info != null) {
                buf.writeBoolean(true);
                InfoHelper.writeInfo(buf, this.info);
            } else {
                buf.writeBoolean(false);
            }
        }
        if (id == 1) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.info.getData());
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            this.info = buf.readBoolean() ? InfoHelper.readInfo(buf) : null;
        }
        if (id == 1) {
            StandardInfo standardInfo = (StandardInfo)this.info;
            standardInfo.setData(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b("currentInfo")) {
            this.info = InfoHelper.readInfo(nbt.func_74775_l("currentInfo"));
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE && this.info != null) {
            NBTTagCompound infoTag = new NBTTagCompound();
            InfoHelper.writeInfo(infoTag, this.info);
            nbt.func_74782_a("currentInfo", (NBTBase)infoTag);
        }
    }
}

