/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.sync.SyncString;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.connecting.IDataConnection;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.InfoHelper;

public class DataModifierHandler
extends TileHandler {
    public SyncString subCategory = new SyncString(0);
    public SyncString prefix = new SyncString(1);
    public SyncString suffix = new SyncString(2);
    public Info info;

    public DataModifierHandler(boolean isMultipart) {
        super(isMultipart);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        CableHelper.updateAdjacentCoords(te, new BlockCoords(te.field_145851_c, te.field_145848_d, te.field_145849_e), false, new ForgeDirection[]{ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite()});
        this.updateData(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.subCategory.readFromNBT(nbt, type);
            this.prefix.readFromNBT(nbt, type);
            this.suffix.readFromNBT(nbt, type);
            if (nbt.func_74764_b("currentInfo")) {
                this.info = InfoHelper.readInfo(nbt.func_74775_l("currentInfo"));
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.subCategory.writeToNBT(nbt, type);
            this.prefix.writeToNBT(nbt, type);
            this.suffix.writeToNBT(nbt, type);
            if (this.info != null) {
                NBTTagCompound infoTag = new NBTTagCompound();
                InfoHelper.writeInfo(infoTag, this.info);
                nbt.func_74782_a("currentInfo", (NBTBase)infoTag);
            }
        }
    }

    public boolean canRenderConnection(TileEntity te, ForgeDirection dir) {
        return CableHelper.canRenderConnection(te, dir);
    }

    public boolean canConnect(ForgeDirection dir) {
        return true;
    }

    public void updateData(TileEntity te, ForgeDirection dir) {
        Object target = CableHelper.getConnectedTile(te, dir.getOpposite());
        if ((target = FMPHelper.checkObject((Object)target)) == null) {
            return;
        }
        if (target instanceof IDataConnection) {
            IDataConnection infoNode = (IDataConnection)target;
            if (infoNode.currentInfo() != null) {
                this.info = infoNode.currentInfo();
            } else if (this.info != null) {
                this.info.emptyData();
            }
        }
    }

    public Info currentInfo() {
        if (this.info == null) {
            return null;
        }
        if (this.info.getProviderID() == -1 && this.info.getCategory().equals("PERCENT")) {
            return this.info;
        }
        String currentSub = this.subCategory.getString();
        String currentPre = this.prefix.getString();
        String currentSuf = this.suffix.getString();
        String subCat = currentSub == null || currentSub.isEmpty() || currentSub.equals("") ? this.info.getSubCategory() : currentSub;
        String prefix = currentPre == null || currentPre.isEmpty() || currentPre.equals("") ? "" : currentPre;
        String suffix = currentSuf == null || currentSuf.isEmpty() || currentSuf.equals("") ? "" : currentSuf;
        StandardInfo modifiedInfo = new StandardInfo(-1, this.info.getCategory(), subCat, (Object)(prefix + " " + this.info.getDisplayableData() + " " + suffix));
        return modifiedInfo;
    }

    public void textTyped(String string, int id) {
        String text = string == null || string.isEmpty() ? " " : string;
        switch (id) {
            case 1: {
                this.prefix.setString(string);
                break;
            }
            case 2: {
                this.suffix.setString(string);
                break;
            }
            default: {
                this.subCategory.setString(string);
            }
        }
    }

    public void removed(World world, int x, int y, int z, int meta) {
        CableHelper.updateAdjacentCoords(world, x, y, z, null, true);
    }
}

