/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.block.SonarMaterials;
import sonar.logistics.Logistics;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.common.blocks.BaseNode;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;

public class BlockDataReceiver
extends BaseNode {
    public BlockDataReceiver() {
        super(SonarMaterials.machine);
        this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
    }

    @Override
    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityDataReceiver();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void openGui(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity target = world.func_147438_o(x, y, z);
        if (target != null && target instanceof TileEntityDataReceiver) {
            TileEntityDataReceiver sonar = (TileEntityDataReceiver)target;
            sonar.sendAvailableData(target, player);
        }
        player.openGui((Object)Logistics.instance, 2, world, x, y, z);
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    @Override
    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, int side, float hitx, float hity, float hitz) {
        return super.operateBlock(world, x, y, z, player, side, hitx, hity, hitz);
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldblock, int oldMetadata) {
        IDataCable cable;
        super.func_149749_a(world, x, y, z, oldblock, oldMetadata);
        ForgeDirection dir = ForgeDirection.getOrientation((int)oldMetadata);
        TileEntity tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (tile != null && tile instanceof IDataCable && (cable = (IDataCable)tile).getCoords() != null) {
            cable.setCoords(null);
        }
    }

    public boolean hasSpecialCollisionBox() {
        return true;
    }

    public List<AxisAlignedBB> getCollisionBoxes(World world, int x, int y, int z, List<AxisAlignedBB> list) {
        this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        list.add(AxisAlignedBB.func_72330_a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75));
        return list;
    }
}

