/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.logistics.common.tileentity.TileEntityDataCable;
import sonar.logistics.helpers.CableHelper;

public class BlockDataCable
extends SonarMachineBlock {
    public BlockDataCable() {
        super(SonarMaterials.machine, false);
        this.func_149676_a(0.1875f, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 0.8125f);
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity != null && tileentity instanceof TileEntityDataCable) {
            TileEntityDataCable cable = (TileEntityDataCable)world.func_147438_o(x, y, z);
            CableHelper.updateAdjacentCoords((TileEntity)cable, cable.coords, true);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        super.func_149689_a(world, x, y, z, entity, itemstack);
        TileEntity target = world.func_147438_o(x, y, z);
        if (entity instanceof EntityPlayer && target instanceof TileEntityDataCable) {
            TileEntityDataCable cable = (TileEntityDataCable)target;
            CableHelper.updateAdjacentCoords((TileEntity)cable, cable.coords, true);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldblock, int oldMetadata) {
        super.func_149749_a(world, x, y, z, oldblock, oldMetadata);
        CableHelper.updateAdjacentCoords(world, x, y, z, null, true);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityDataCable();
    }

    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, int side, float hitx, float hity, float hitz) {
        return false;
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        super.func_149719_a(world, x, y, z);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity != null && tileentity instanceof TileEntityDataCable) {
            TileEntityDataCable cable = (TileEntityDataCable)world.func_147438_o(x, y, z);
            this.func_149676_a((float)(cable.canRenderConnection(ForgeDirection.WEST) ? 0.0 : 0.375), (float)(cable.canRenderConnection(ForgeDirection.DOWN) ? 0.0 : 0.375), (float)(cable.canRenderConnection(ForgeDirection.NORTH) ? 0.0 : 0.375), (float)(cable.canRenderConnection(ForgeDirection.EAST) ? 1.0 : 0.625), (float)(cable.canRenderConnection(ForgeDirection.UP) ? 1.0 : 0.625), (float)(cable.canRenderConnection(ForgeDirection.SOUTH) ? 1.0 : 0.625));
        } else {
            this.func_149676_a(0.375f, 0.375f, 0.375f, 0.625f, 0.625f, 0.625f);
        }
    }

    public boolean hasSpecialCollisionBox() {
        return true;
    }

    public List<AxisAlignedBB> getCollisionBoxes(World world, int x, int y, int z, List<AxisAlignedBB> list) {
        this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        list.add(AxisAlignedBB.func_72330_a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75));
        list.add(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.1f, (double)1.0));
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
    }

    public boolean dropStandard(World world, int x, int y, int z) {
        return true;
    }
}

