/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.renderers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.utils.helpers.RenderHelper;
import sonar.logistics.api.Info;
import sonar.logistics.api.connecting.ILargeDisplay;
import sonar.logistics.api.render.LargeScreenSizing;
import sonar.logistics.client.models.ModelLargeDisplay;
import sonar.logistics.client.renderers.RenderDisplayScreen;
import sonar.logistics.client.renderers.RenderHandlers;
import sonar.logistics.common.handlers.LargeDisplayScreenHandler;
import sonar.logistics.registries.BlockRegistry;

public class RenderLargeDisplay
extends RenderDisplayScreen {
    public ModelLargeDisplay model = new ModelLargeDisplay();
    public String none = RenderHandlers.modelFolder + "screen-parts/" + "large_display_none.png";
    public String all = RenderHandlers.modelFolder + "screen-parts/" + "large_display_all.png";
    public String one = RenderHandlers.modelFolder + "screen-parts/" + "large_display_one.png";
    public String opposite = RenderHandlers.modelFolder + "screen-parts/" + "large_display_opposite.png";
    public String two = RenderHandlers.modelFolder + "screen-parts/" + "large_display_two.png";
    public String three = RenderHandlers.modelFolder + "screen-parts/" + "large_display_three.png";

    @Override
    public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
        List<ForgeDirection> connections = this.connectedDir(entity);
        RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.getTexture(connections));
        float rotate = this.getRotation(connections, RenderHelper.setMetaData((TileEntity)entity));
        if (rotate == 90.0f) {
            GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
        }
        if (rotate == -90.0f) {
            GL11.glTranslated((double)-1.0, (double)1.0, (double)0.0);
        }
        if (rotate == 180.0f) {
            GL11.glTranslated((double)0.0, (double)2.0, (double)0.0);
        }
        GL11.glRotated((double)rotate, (double)0.0, (double)0.0, (double)1.0);
        this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        Tessellator tess = Tessellator.field_78398_a;
        if (entity.func_145831_w() != null) {
            ILargeDisplay display;
            Object target = FMPHelper.checkObject((Object)entity);
            if (!(target instanceof ILargeDisplay)) {
                target = FMPHelper.getHandler((Object)target);
            }
            if (target instanceof ILargeDisplay && (display = (ILargeDisplay)target).isHandler()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                ForgeDirection d = ForgeDirection.getOrientation((int)RenderHelper.setMetaData((TileEntity)entity));
                float move = -0.23f;
                GL11.glTranslated((double)((float)d.offsetX * move), (double)((float)d.offsetY * move), (double)((float)d.offsetZ * move));
                this.tesrRenderScreen(tess, entity, d);
                GL11.glPopMatrix();
            }
        }
    }

    public float getRotation(List<ForgeDirection> dirs, int meta) {
        if (dirs == null || dirs.isEmpty() || dirs.size() == 0) {
            return 0.0f;
        }
        ForgeDirection metaDir = ForgeDirection.getOrientation((int)meta);
        switch (dirs.size()) {
            case 1: {
                if (dirs.get(0) == metaDir.getRotation(ForgeDirection.UP)) {
                    return 90.0f;
                }
                if (dirs.get(0) == metaDir.getRotation(ForgeDirection.UP).getOpposite()) {
                    return -90.0f;
                }
                if (dirs.get(0) == ForgeDirection.DOWN) {
                    return 0.0f;
                }
                if (dirs.get(0) == ForgeDirection.UP) {
                    return 180.0f;
                }
                return 90.0f;
            }
            case 2: {
                if (dirs.get(0).getOpposite() == dirs.get(1)) {
                    if (dirs.get(0) == ForgeDirection.DOWN && dirs.get(1) == ForgeDirection.UP) {
                        return 90.0f;
                    }
                    return 0.0f;
                }
                if (dirs.get(0) == ForgeDirection.DOWN) {
                    if (dirs.get(1) == metaDir.getRotation(ForgeDirection.UP)) {
                        return 180.0f;
                    }
                    if (dirs.get(1) == metaDir.getRotation(ForgeDirection.UP).getOpposite()) {
                        return 90.0f;
                    }
                }
                if (dirs.get(0) == ForgeDirection.UP) {
                    if (dirs.get(1) == metaDir.getRotation(ForgeDirection.UP)) {
                        return -90.0f;
                    }
                    if (dirs.get(1) == metaDir.getRotation(ForgeDirection.UP).getOpposite()) {
                        return 0.0f;
                    }
                }
                return 0.0f;
            }
            case 3: {
                if (!dirs.contains(ForgeDirection.DOWN)) {
                    return 0.0f;
                }
                if (!dirs.contains(ForgeDirection.UP)) {
                    return 180.0f;
                }
                if (!dirs.contains(metaDir.getRotation(ForgeDirection.UP))) {
                    return 90.0f;
                }
                if (!dirs.contains(metaDir.getRotation(ForgeDirection.UP).getOpposite())) {
                    return -90.0f;
                }
                return 0.0f;
            }
            case 4: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public String getTexture(List<ForgeDirection> dirs) {
        if (dirs == null || dirs.isEmpty() || dirs.size() == 0) {
            return this.none;
        }
        switch (dirs.size()) {
            case 1: {
                return this.one;
            }
            case 2: {
                if (dirs.get(0).getOpposite() == dirs.get(1)) {
                    return this.opposite;
                }
                return this.two;
            }
            case 3: {
                return this.three;
            }
            case 4: {
                return this.all;
            }
        }
        return this.none;
    }

    public List<ForgeDirection> connectedDir(TileEntity tile) {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        if (tile != null && tile.func_145831_w() != null) {
            int meta = tile.func_145832_p();
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                if (dir == ForgeDirection.getOrientation((int)meta) || dir == ForgeDirection.getOrientation((int)meta).getOpposite()) continue;
                Block block = tile.func_145831_w().func_147439_a(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ);
                int blockMeta = tile.func_145831_w().func_72805_g(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ);
                if (block == null || block != BlockRegistry.largeDisplayScreen || meta != blockMeta) continue;
                dirs.add(dir);
            }
        }
        return dirs;
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, ForgeDirection side, Info info) {
        LargeScreenSizing sizing = null;
        Object target = FMPHelper.checkObject((Object)tile);
        if (!(target instanceof ILargeDisplay)) {
            target = FMPHelper.getHandler((Object)target);
        }
        if (target instanceof LargeDisplayScreenHandler) {
            LargeDisplayScreenHandler display = (LargeDisplayScreenHandler)target;
            sizing = display.sizing;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)tile.func_145832_p()).getRotation(ForgeDirection.UP);
        boolean north = false;
        if (dir.offsetZ == 1 || dir.offsetX == 1) {
            north = true;
        }
        if (sizing == null || sizing.maxH == 0 && sizing.minH == 0 && sizing.maxY == 0 && sizing.minY == 0) {
            float pixel = 0.0625f;
            info.renderInfo(tess, tile, -0.5f + pixel, -0.44f, 1.0f - pixel * 9.0f, pixel * 14.0f, -0.2f, 110.0f);
        } else {
            float pixel = 0.0625f;
            info.renderInfo(tess, tile, -0.5f + pixel + (float)(north ? -sizing.maxH : sizing.minH), -0.44f - (float)sizing.maxY, 1.0f - pixel * 9.0f + (float)(north ? -sizing.minH : sizing.maxH), pixel * 14.0f + (float)sizing.minY + (float)sizing.maxY, -0.2f, 40.0f);
        }
    }
}

