/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.core.inventory.GuiSonar;
import sonar.core.inventory.SonarButtons;
import sonar.core.inventory.StoredItemStack;
import sonar.core.utils.helpers.FontHelper;
import sonar.logistics.Logistics;
import sonar.logistics.common.containers.ContainerInventoryReader;
import sonar.logistics.common.handlers.InventoryReaderHandler;
import sonar.logistics.network.packets.PacketInventoryReader;

public class GuiInventoryReader
extends GuiSonar {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public InventoryReaderHandler handler;
    public TileEntity tile;
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/inventoryReader.png");
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    public int cycle;

    public GuiInventoryReader(InventoryReaderHandler handler, TileEntity entity, InventoryPlayer inventoryPlayer) {
        super((Container)new ContainerInventoryReader(handler, entity, inventoryPlayer), entity);
        this.xCoord = entity.field_145851_c;
        this.yCoord = entity.field_145848_d;
        this.zCoord = entity.field_145849_e;
        this.handler = handler;
        this.tile = entity;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 248;
        this.field_147000_g = 256;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 164 + 68;
        this.scrollerStart = this.field_147009_r + 31;
        this.scrollerEnd = this.scrollerStart + 128;
        this.scrollerWidth = 10;
    }

    public List<Integer> getCategoryPositions() {
        if (this.getStacks() == null) {
            return null;
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int start = (int)((float)this.stackListSize() * this.currentScroll);
        int finish = Math.min(start + 84, this.stackListSize());
        for (int i = start; i < finish; ++i) {
            if (this.getStacks().get(i) == null) continue;
            StoredItemStack storedItemStack = this.getStacks().get(i);
        }
        return positions;
    }

    protected void func_73864_a(int x, int y, int button) {
        StoredItemStack storedStack;
        int Y;
        int X;
        int start;
        int i;
        super.func_73864_a(x, y, button);
        if ((button == 0 || button == 1) && x - this.field_147003_i >= 13 && x - this.field_147003_i <= 229 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158 && (i = (start = (int)((float)(this.stackListSize() / 12) * this.currentScroll)) * 12 + (X = (x - this.field_147003_i - 13) / 18) + (Y = (y - this.field_147009_r - 32) / 18) * 12) < this.getStacks().size() && (storedStack = this.getStacks().get(i)) != null) {
            this.handler.current = storedStack.item;
            this.handler.current.field_77994_a = 1;
            Logistics.network.sendToServer((IMessage)new PacketInventoryReader(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.handler.current));
        }
    }

    public void func_146979_b(int x, int y) {
        StoredItemStack storedStack;
        int Y;
        int X;
        int i;
        int start;
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)StatCollector.func_74838_a((String)"tile.InventoryReader.name"), (int)this.field_146999_f, (int)6, (int)1);
        FontHelper.textCentre((String)"Click the item you wish to monitor", (int)this.field_146999_f, (int)18, (int)0);
        this.cycle = this.cycle == 100 ? 0 : ++this.cycle;
        if (this.getStacks() != null) {
            start = (int)((float)(this.stackListSize() / 12) * this.currentScroll);
            int i2 = start * 12;
            int finish = Math.min(i2 + 84, this.stackListSize());
            for (int Y2 = 0; Y2 < 7; ++Y2) {
                for (int X2 = 0; X2 < 12; ++X2) {
                    StoredItemStack storedStack2;
                    if (i2 < finish && (storedStack2 = this.getStacks().get(i2)) != null) {
                        ItemStack stack = storedStack2.item;
                        stack.field_77994_a = (int)storedStack2.stored;
                        RenderItem.getInstance().func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, 13 + X2 * 18, 32 + Y2 * 18);
                        sonar.core.utils.helpers.RenderHelper.renderStoredItemStackOverlay((FontRenderer)this.field_146289_q, (TextureManager)this.field_146297_k.func_110434_K(), (ItemStack)stack, (long)storedStack2.stored, (int)(13 + X2 * 18), (int)(32 + Y2 * 18), null);
                    }
                    ++i2;
                }
            }
        }
        if (x - this.field_147003_i >= 13 && x - this.field_147003_i <= 229 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158 && (i = (start = (int)((float)(this.stackListSize() / 12) * this.currentScroll)) * 12 + (X = (x - this.field_147003_i - 13) / 18) + (Y = (y - this.field_147009_r - 32) / 18) * 12) < this.getStacks().size() && (storedStack = this.getStacks().get(i)) != null) {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2896);
            this.renderToolTip(storedStack, x - this.field_147003_i, y - this.field_147009_r);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
        }
    }

    protected void renderToolTip(StoredItemStack stored, int x, int y) {
        List list = stored.item.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        list.add(1, "Stored: " + stored.stored);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, stored.item.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = stored.item.func_77973_b().getFontRenderer(stored.item);
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
    }

    public void func_146274_d() {
        super.func_146274_d();
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.stackListSize() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 248, 0, 8, 15);
    }

    private boolean needsScrollBars() {
        return this.stackListSize() > 84;
    }

    public ResourceLocation getBackground() {
        return bground;
    }

    public int stackListSize() {
        return this.getStacks() == null ? 0 : this.getStacks().size();
    }

    public List<StoredItemStack> getStacks() {
        return this.handler.stacks;
    }

    @SideOnly(value=Side.CLIENT)
    public class NetworkButton
    extends SonarButtons.ImageButton {
        public NetworkButton(int id, int x, int y) {
            super(id, x, y, bground, 0, 202, 226, 11);
        }
    }
}

