/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.core.inventory.GuiSonar;
import sonar.core.inventory.SonarButtons;
import sonar.core.utils.helpers.FontHelper;
import sonar.logistics.Logistics;
import sonar.logistics.api.Info;
import sonar.logistics.common.containers.ContainerInfoNode;
import sonar.logistics.common.handlers.InfoReaderHandler;
import sonar.logistics.info.types.CategoryInfo;
import sonar.logistics.network.packets.PacketInfoBlock;

public class GuiInfoReader
extends GuiSonar {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public InfoReaderHandler handler;
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/infoselect.png");
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    private GuiButton rselectButton;

    public GuiInfoReader(InfoReaderHandler handler, TileEntity tile) {
        super((Container)new ContainerInfoNode(handler, tile), tile);
        this.xCoord = tile.field_145851_c;
        this.yCoord = tile.field_145848_d;
        this.zCoord = tile.field_145849_e;
        this.handler = handler;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 248;
        this.field_147000_g = 166;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 164 + 72;
        this.scrollerStart = this.field_147009_r + 29;
        this.scrollerEnd = this.scrollerStart + 134;
        this.scrollerWidth = 10;
        for (int i = 0; i < 11; ++i) {
            this.field_146292_n.add(new NetworkButton(10 + i, this.field_147003_i + 7, this.field_147009_r + 29 + i * 12));
        }
    }

    public int getDataPosition() {
        if (this.getPrimaryInfo() == null) {
            return -1;
        }
        if (this.getInfo() == null) {
            return -1;
        }
        int start = (int)((float)this.infoSize() * this.currentScroll);
        int finish = Math.min(start + 11, this.infoSize());
        for (int i = start; i < finish; ++i) {
            Info info;
            if (this.getInfo().get(i) == null || (info = this.getInfo().get(i)) == null || !info.isEqualType(this.getPrimaryInfo())) continue;
            return i - start;
        }
        return -1;
    }

    public int getSecondaryPosition() {
        if (this.getSecondInfo() == null) {
            return -1;
        }
        if (this.getInfo() == null) {
            return -1;
        }
        int start = (int)((float)this.infoSize() * this.currentScroll);
        int finish = Math.min(start + 11, this.infoSize());
        for (int i = start; i < finish; ++i) {
            Info info;
            if (this.getInfo().get(i) == null || (info = this.getInfo().get(i)) == null || !info.isEqualType(this.getSecondInfo())) continue;
            return i - start;
        }
        return -1;
    }

    public List<Integer> getCategoryPositions() {
        if (this.getInfo() == null) {
            return null;
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int start = (int)((float)this.infoSize() * this.currentScroll);
        int finish = Math.min(start + 11, this.infoSize());
        for (int i = start; i < finish; ++i) {
            Info info;
            if (this.getInfo().get(i) == null || !((info = this.getInfo().get(i)) instanceof CategoryInfo)) continue;
            positions.add(i - start);
        }
        return positions;
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)StatCollector.func_74838_a((String)"tile.InfoReader.name"), (int)this.field_146999_f, (int)6, (int)1);
        FontHelper.textCentre((String)"Select the data you wish to monitor", (int)this.field_146999_f, (int)18, (int)0);
        if (this.getInfo() != null) {
            int start = (int)((float)this.infoSize() * this.currentScroll);
            int finish = Math.min(start + 11, this.infoSize());
            for (int i = start; i < finish; ++i) {
                Info info = this.getInfo().get(i);
                if (info == null) continue;
                boolean isSelected = info.isEqualType(this.getPrimaryInfo());
                if (!(info instanceof CategoryInfo)) {
                    int colour = isSelected ? Color.green.getRGB() : Color.lightGray.getRGB();
                    FontHelper.text((String)info.getSubCategory().substring(0, Math.min(16, info.getSubCategory().length())), (int)10, (int)(31 + 12 * i - 12 * start), (int)colour);
                    FontHelper.text((String)info.getDisplayableData().substring(0, Math.min(25, info.getDisplayableData().length())), (int)102, (int)(31 + 12 * i - 12 * start), (int)colour);
                    continue;
                }
                FontHelper.text((String)info.getSubCategory(), (int)10, (int)(31 + 12 * i - 12 * start), (int)Color.BLACK.getRGB());
            }
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.infoSize() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 1) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, x, y)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.rselectButton = event.button;
                event.button.func_146113_a(this.field_146297_k.func_147118_V());
                this.buttonPressed(event.button, 1);
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.button, this.field_146292_n));
            }
        }
    }

    protected void func_146286_b(int x, int y, int id) {
        super.func_146286_b(x, y, id);
        if (this.rselectButton != null && id == 1) {
            this.rselectButton.func_146118_a(x, y);
            this.rselectButton = null;
        }
    }

    protected void buttonPressed(GuiButton button, int buttonID) {
        int start;
        int network;
        if (button != null && button.field_146127_k >= 10 && this.getInfo() != null && (network = (start = (int)((float)this.infoSize() * this.currentScroll)) + button.field_146127_k - 10) < this.infoSize()) {
            Info info = this.getInfo().get(network);
            if (info == null || info instanceof CategoryInfo) {
                return;
            }
            if (buttonID == 0) {
                if (this.getPrimaryInfo() != null && info.isEqualType(this.getPrimaryInfo())) {
                    Logistics.network.sendToServer((IMessage)new PacketInfoBlock(this.xCoord, this.yCoord, this.zCoord, true));
                    if (this.handler.isMultipart.getBoolean()) {
                        this.handler.primaryInfo = null;
                    }
                } else {
                    Logistics.network.sendToServer((IMessage)new PacketInfoBlock(this.xCoord, this.yCoord, this.zCoord, info, true));
                    if (this.handler.isMultipart.getBoolean()) {
                        this.handler.primaryInfo.setInfo(info);
                    }
                }
            } else if (buttonID == 1 && !info.isEqualType(this.getPrimaryInfo())) {
                if (this.getSecondInfo() != null && info.isEqualType(this.getSecondInfo())) {
                    Logistics.network.sendToServer((IMessage)new PacketInfoBlock(this.xCoord, this.yCoord, this.zCoord, false));
                    if (this.handler.isMultipart.getBoolean()) {
                        this.handler.secondaryInfo = null;
                    }
                } else {
                    Logistics.network.sendToServer((IMessage)new PacketInfoBlock(this.xCoord, this.yCoord, this.zCoord, info, false));
                    if (this.handler.isMultipart.getBoolean()) {
                        this.handler.secondaryInfo.setInfo(info);
                    }
                }
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        this.buttonPressed(button, 0);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        List<Integer> positions = this.getCategoryPositions();
        int primary = this.getDataPosition();
        int secondary = this.getSecondaryPosition();
        for (int i = 0; i < 11; ++i) {
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 29 + 12 * i, 0, positions != null && positions.contains(i) ? 190 : (i == primary ? 178 : (i == secondary ? 202 : 166)), 226, 12);
        }
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 248, 0, 8, 15);
    }

    private boolean needsScrollBars() {
        return this.infoSize() > 11;
    }

    public ResourceLocation getBackground() {
        return bground;
    }

    public int infoSize() {
        return this.getInfo() == null ? 0 : this.getInfo().size();
    }

    public List<Info> getInfo() {
        return this.handler.clientInfo;
    }

    public Info getPrimaryInfo() {
        return this.handler.primaryInfo.getInfo();
    }

    public Info getSecondInfo() {
        return this.handler.secondaryInfo.getInfo();
    }

    @SideOnly(value=Side.CLIENT)
    public class NetworkButton
    extends SonarButtons.ImageButton {
        public NetworkButton(int id, int x, int y) {
            super(id, x, y, bground, 0, 224, 226, 11);
        }
    }
}

