/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.core.fluid.StoredFluidStack;
import sonar.core.inventory.GuiSonar;
import sonar.core.inventory.SonarButtons;
import sonar.core.utils.helpers.FontHelper;
import sonar.logistics.Logistics;
import sonar.logistics.common.containers.ContainerFluidReader;
import sonar.logistics.common.handlers.FluidReaderHandler;
import sonar.logistics.network.packets.PacketFluidReader;

public class GuiFluidReader
extends GuiSonar {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public FluidReaderHandler handler;
    public TileEntity tile;
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/inventoryReader.png");
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    public int cycle;

    public GuiFluidReader(FluidReaderHandler handler, TileEntity entity, InventoryPlayer inventoryPlayer) {
        super((Container)new ContainerFluidReader(handler, entity, inventoryPlayer), entity);
        this.xCoord = entity.field_145851_c;
        this.yCoord = entity.field_145848_d;
        this.zCoord = entity.field_145849_e;
        this.handler = handler;
        this.tile = entity;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 248;
        this.field_147000_g = 256;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 164 + 68;
        this.scrollerStart = this.field_147009_r + 31;
        this.scrollerEnd = this.scrollerStart + 128;
        this.scrollerWidth = 10;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0 || button == 1) {
            StoredFluidStack fluidStack;
            int Y;
            int X;
            int start;
            int i;
            if (x - this.field_147003_i >= 13 && x - this.field_147003_i <= 229 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158 && (i = (start = (int)((float)(this.stackListSize() / 12) * this.currentScroll)) * 12 + (X = (x - this.field_147003_i - 13) / 18) + (Y = (y - this.field_147009_r - 32) / 18) * 12) < this.getStacks().size() && (fluidStack = this.getStacks().get(i)) != null && fluidStack.fluid != null) {
                Logistics.network.sendToServer((IMessage)new PacketFluidReader(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, fluidStack.fluid));
            }
            if (x - this.field_147003_i < 13 || x - this.field_147003_i > 29 || y - this.field_147009_r < 9 || y - this.field_147009_r <= 25) {
                // empty if block
            }
        }
    }

    public void func_146979_b(int x, int y) {
        FluidStack storedStack;
        int var12;
        int var11;
        int br;
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)StatCollector.func_74838_a((String)"tile.FluidReader.name"), (int)this.field_146999_f, (int)6, (int)1);
        FontHelper.textCentre((String)"Click the fluid you wish to monitor", (int)this.field_146999_f, (int)18, (int)0);
        this.cycle = this.cycle == 100 ? 0 : ++this.cycle;
        if (this.getStacks() != null) {
            br = 0x1000100;
            var11 = 256;
            var12 = 256;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.8f, (float)204.8f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int start = (int)((float)(this.stackListSize() / 12) * this.currentScroll);
            int i = start * 12;
            int finish = Math.min(i + 84, this.stackListSize());
            for (int Y = 0; Y < 7; ++Y) {
                for (int X = 0; X < 12; ++X) {
                    StoredFluidStack fluidStack;
                    if (i < finish && (fluidStack = this.getStacks().get(i)) != null && fluidStack.fluid != null) {
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                        RenderItem.getInstance().func_94149_a(13 + X * 18, 32 + Y * 18, fluidStack.fluid.getFluid().getIcon(), 16, 16);
                        sonar.core.utils.helpers.RenderHelper.renderFluidInGUI((FontRenderer)Minecraft.func_71410_x().field_71466_p, (TextureManager)Minecraft.func_71410_x().func_110434_K(), (FluidStack)fluidStack.fluid, (long)fluidStack.stored, (int)(13 + X * 18), (int)(32 + Y * 18), null);
                    }
                    ++i;
                }
            }
        }
        if (this.handler.current != null) {
            br = 0x1000100;
            var11 = 256;
            var12 = 256;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            RenderItem.getInstance().func_94149_a(13, 9, this.handler.current.getFluid().getIcon(), 16, 16);
        }
        if (x - this.field_147003_i >= 13 && x - this.field_147003_i <= 229 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158) {
            StoredFluidStack storedStack2;
            int start = (int)((float)(this.stackListSize() / 12) * this.currentScroll);
            int X = (x - this.field_147003_i - 13) / 18;
            int Y = (y - this.field_147009_r - 32) / 18;
            int i = start * 12 + X + Y * 12;
            if (this.getStacks() != null && i < this.getStacks().size() && (storedStack2 = this.getStacks().get(i)) != null && storedStack2.fluid != null) {
                GL11.glDisable((int)2929);
                GL11.glDisable((int)2896);
                this.renderToolTip(storedStack2, x - this.field_147003_i, y - this.field_147009_r);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                RenderHelper.func_74520_c();
            }
        }
        if (x - this.field_147003_i >= 13 && x - this.field_147003_i <= 29 && y - this.field_147009_r >= 9 && y - this.field_147009_r <= 25 && (storedStack = this.handler.current) != null) {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2896);
            this.renderToolTip(storedStack, x - this.field_147003_i, y - this.field_147009_r);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
        }
    }

    protected void renderToolTip(FluidStack storedStack, int x, int y) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(storedStack.getLocalizedName());
        this.drawHoveringText(list, x, y, this.field_146289_q);
    }

    protected void renderToolTip(StoredFluidStack storedStack, int x, int y) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(storedStack.fluid.getFluid().getLocalizedName(storedStack.fluid));
        if (storedStack.stored != 0L) {
            list.add(EnumChatFormatting.GRAY + "Stored: " + storedStack.stored + " mB");
        }
        this.drawHoveringText(list, x, y, this.field_146289_q);
    }

    public void func_146274_d() {
        super.func_146274_d();
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.stackListSize() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 248, 0, 8, 15);
    }

    private boolean needsScrollBars() {
        return this.stackListSize() > 84;
    }

    public ResourceLocation getBackground() {
        return bground;
    }

    public int stackListSize() {
        return this.getStacks() == null ? 0 : this.getStacks().size();
    }

    public List<StoredFluidStack> getStacks() {
        return this.handler.stacks;
    }

    @SideOnly(value=Side.CLIENT)
    public class NetworkButton
    extends SonarButtons.ImageButton {
        public NetworkButton(int id, int x, int y) {
            super(id, x, y, bground, 0, 202, 226, 11);
        }
    }
}

