/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.core.inventory.GuiSonar;
import sonar.core.inventory.SonarButtons;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.FontHelper;
import sonar.logistics.Logistics;
import sonar.logistics.api.DataEmitter;
import sonar.logistics.common.containers.ContainerDataReceiver;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;
import sonar.logistics.network.packets.PacketDataReceiver;

public class GuiDataReceiver
extends GuiSonar {
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/dataReceiver.png");
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    public TileEntityDataReceiver tile;
    public int cycle;

    public GuiDataReceiver(InventoryPlayer inventory, TileEntityDataReceiver tile) {
        super((Container)new ContainerDataReceiver(tile, inventory), (TileEntity)tile);
        this.tile = tile;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 248;
        this.field_147000_g = 166;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 164 + 72;
        this.scrollerStart = this.field_147009_r + 29;
        this.scrollerEnd = this.scrollerStart + 134;
        this.scrollerWidth = 10;
        for (int i = 0; i < 11; ++i) {
            this.field_146292_n.add(new NetworkButton(10 + i, this.field_147003_i + 7, this.field_147009_r + 29 + i * 12));
        }
    }

    public int getDataPosition() {
        if (this.tile.emitter.getEmitter() == null) {
            return -1;
        }
        if (this.tile.emitters == null) {
            return -1;
        }
        int start = (int)((float)this.emitterSize() * this.currentScroll);
        int finish = Math.min(start + 11, this.emitterSize());
        for (int i = start; i < finish; ++i) {
            if (this.tile.emitters.get(i) == null) continue;
            DataEmitter info = this.tile.emitters.get(i);
            if (!BlockCoords.equalCoords((BlockCoords)info.coords, (BlockCoords)this.tile.emitter.getEmitter().coords)) continue;
            return i - start;
        }
        return -1;
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)StatCollector.func_74838_a((String)"tile.DataReceiver.name"), (int)this.field_146999_f, (int)6, (int)1);
        FontHelper.textCentre((String)"Select the emitter you wish to connect to", (int)this.field_146999_f, (int)18, (int)0);
        this.cycle = this.cycle == 100 ? 0 : ++this.cycle;
        if (this.tile.emitters != null) {
            int start = (int)((float)this.emitterSize() * this.currentScroll);
            int finish = Math.min(start + 11, this.emitterSize());
            int pos = this.getDataPosition();
            for (int i = start; i < finish; ++i) {
                DataEmitter emitter = this.tile.emitters.get(i);
                if (emitter == null) continue;
                boolean isSelected = pos == i;
                FontHelper.text((String)emitter.name, (int)10, (int)(31 + 12 * i - 12 * start), (int)(isSelected ? Color.GREEN.getRGB() : Color.WHITE.getRGB()));
                GL11.glPushMatrix();
                GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
                FontHelper.text((String)("D: " + emitter.coords.getDimension() + " " + emitter.coords.getRender()), (int)174, (int)(43 + 16 * i - 16 * start), (int)(isSelected ? Color.GREEN.getRGB() : Color.WHITE.getRGB()));
                GL11.glPopMatrix();
            }
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.emitterSize() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        int start;
        int network;
        if (button != null && button.field_146127_k >= 10 && this.tile.emitters != null && (network = (start = (int)((float)this.emitterSize() * this.currentScroll)) + button.field_146127_k - 10) < this.emitterSize() && this.tile.emitters.get(network) != null) {
            Logistics.network.sendToServer((IMessage)new PacketDataReceiver(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.tile.emitters.get(network)));
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int pos = this.getDataPosition();
        for (int i = 0; i < 11; ++i) {
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 29 + 12 * i, 0, i == pos ? 178 : 166, 226, 12);
        }
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 248, 0, 8, 15);
    }

    private boolean needsScrollBars() {
        return this.emitterSize() > 11;
    }

    public ResourceLocation getBackground() {
        return bground;
    }

    public int emitterSize() {
        return this.tile.emitters == null ? 0 : this.tile.emitters.size();
    }

    @SideOnly(value=Side.CLIENT)
    public class NetworkButton
    extends SonarButtons.ImageButton {
        public NetworkButton(int id, int x, int y) {
            super(id, x, y, bground, 0, 202, 226, 11);
        }
    }
}

