/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.render;

import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;
import sonar.logistics.api.Info;

public class InfoRenderer {
    public static void renderStandardInfo(Info info, FontRenderer rend, float minX, float minY, float maxX, float maxY, float zOffset, float scale) {
        GL11.glTranslatef((float)(minX + (maxX - minX) / 2.0f), (float)(minY + maxY / 2.0f), (float)0.01f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)zOffset);
        int sizing = Math.round(Math.min(maxX - minX, (maxY - minY) * 3.0f));
        double itemScale = sizing >= 2 ? InfoRenderer.getScale(sizing) : 120.0;
        GL11.glScaled((double)(1.0 / itemScale), (double)(1.0 / itemScale), (double)(1.0 / itemScale));
        String category = info.getSubCategory();
        String data = info.getDisplayableData();
        if (category.isEmpty() || category.equals(" ")) {
            rend.func_78276_b(data, -rend.func_78256_a(data) / 2, -4, -1);
        } else {
            rend.func_78276_b(category, -rend.func_78256_a(category) / 2, -8, -1);
            rend.func_78276_b(data, -rend.func_78256_a(data) / 2, 4, -1);
        }
    }

    public static double getScale(int sizing) {
        switch (sizing) {
            case 0: {
                return 120.0;
            }
            case 2: {
                return 70.0;
            }
            case 3: {
                return 40.0;
            }
            case 4: {
                return 30.0;
            }
            case 5: {
                return 22.0;
            }
        }
        return 18.0;
    }
}

