/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.logistics.Logistics;
import sonar.logistics.api.Info;
import sonar.logistics.api.providers.TileProvider;

public class StandardInfo
extends Info {
    public boolean emptyData;
    public String category = "ERROR";
    public String subCategory = "ERROR";
    public String data;
    public String suffix;
    public int dataType;
    public byte providerID = (byte)-1;
    public byte catID = (byte)-1;
    public byte subCatID = (byte)-1;

    public StandardInfo() {
    }

    public StandardInfo(byte providerID, int category, int subCategory, Object data, String suffix) {
        this((int)providerID, category, subCategory, data);
        this.suffix = suffix;
    }

    public StandardInfo(byte providerID, String category, String subCategory, Object data, String suffix) {
        this((int)providerID, category, subCategory, data);
        this.suffix = suffix;
    }

    public StandardInfo(int providerID, int category, int subCategory, Object data) {
        this.providerID = (byte)providerID;
        this.catID = (byte)category;
        this.subCatID = (byte)subCategory;
        this.data = data.toString();
        this.dataType = data instanceof Integer ? 0 : 1;
    }

    public StandardInfo(int providerID, String category, String subCategory, Object data) {
        this.providerID = (byte)providerID;
        this.category = category;
        this.subCategory = subCategory;
        this.data = data.toString();
        this.dataType = data instanceof Integer ? 0 : 1;
    }

    @Override
    public String getName() {
        return "Standard";
    }

    @Override
    public byte getProviderID() {
        return this.providerID;
    }

    @Override
    public String getCategory() {
        return this.catID == -1 || this.providerID == -1 ? this.category : ((TileProvider)Logistics.tileProviders.getRegisteredObject(this.providerID)).getCategory(this.catID);
    }

    @Override
    public String getSubCategory() {
        return this.subCatID == -1 || this.providerID == -1 ? this.subCategory : ((TileProvider)Logistics.tileProviders.getRegisteredObject(this.providerID)).getSubCategory(this.subCatID);
    }

    @Override
    public String getData() {
        return !this.emptyData ? this.data : (this.dataType == 1 ? "NO DATA" : String.valueOf(0));
    }

    @Override
    public String getDisplayableData() {
        if (this.suffix != null) {
            return this.getData() + " " + this.suffix;
        }
        return this.getData();
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.providerID = buf.readByte();
        if (buf.readBoolean()) {
            this.catID = buf.readByte();
        } else {
            this.category = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        if (buf.readBoolean()) {
            this.subCatID = buf.readByte();
        } else {
            this.subCategory = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dataType = buf.readInt();
        this.emptyData = buf.readBoolean();
        if (buf.readBoolean()) {
            this.suffix = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeByte((int)this.providerID);
        if (this.catID != -1) {
            buf.writeBoolean(true);
            buf.writeByte((int)this.catID);
        } else {
            buf.writeBoolean(false);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.category);
        }
        if (this.subCatID != -1) {
            buf.writeBoolean(true);
            buf.writeByte((int)this.subCatID);
        } else {
            buf.writeBoolean(false);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.subCategory);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
        buf.writeInt(this.dataType);
        buf.writeBoolean(this.emptyData);
        if (this.suffix != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.suffix);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.providerID = tag.func_74771_c("prov");
        if (tag.func_74767_n("BcatID")) {
            this.catID = tag.func_74771_c("catID");
        } else {
            this.category = tag.func_74779_i("category");
        }
        if (tag.func_74767_n("BsubCatID")) {
            this.subCatID = tag.func_74771_c("subCatID");
        } else {
            this.subCategory = tag.func_74779_i("subCategory");
        }
        this.data = tag.func_74779_i("data");
        this.dataType = tag.func_74762_e("dataType");
        this.emptyData = tag.func_74767_n("emptyData");
        if (tag.func_74767_n("hasSuffix")) {
            this.suffix = tag.func_74779_i("suffix");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("prov", this.providerID);
        if (this.catID != -1) {
            tag.func_74757_a("BcatID", true);
            tag.func_74774_a("catID", this.catID);
        } else {
            tag.func_74757_a("BcatID", false);
            tag.func_74778_a("category", this.category);
        }
        if (this.subCatID != -1) {
            tag.func_74757_a("BsubCatID", true);
            tag.func_74774_a("subCatID", this.subCatID);
        } else {
            tag.func_74757_a("BsubCatID", false);
            tag.func_74778_a("subCategory", this.subCategory);
        }
        tag.func_74778_a("data", this.data);
        tag.func_74768_a("dataType", this.dataType);
        tag.func_74757_a("emptyData", this.emptyData);
        if (this.suffix != null) {
            tag.func_74757_a("hasSuffix", true);
            tag.func_74778_a("suffix", this.suffix);
        } else {
            tag.func_74757_a("hasSuffix", false);
        }
    }

    @Override
    public boolean isEqualType(Info info) {
        if (info != null && (info.getName().equals("Fluid-Info") || info.getName().equals(this.getName()))) {
            return info.getProviderID() == this.providerID && info.getCategory().equals(this.getCategory()) && info.getSubCategory().equals(this.getSubCategory());
        }
        return false;
    }

    @Override
    public void emptyData() {
        if (!this.emptyData) {
            this.emptyData = true;
        }
    }

    public StandardInfo newInfo() {
        return new StandardInfo();
    }

    public void setData(String string) {
        this.data = string;
    }
}

