/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.core.utils.IRegistryObject;
import sonar.logistics.api.render.InfoRenderer;

public abstract class Info<T extends Info>
implements IRegistryObject {
    public abstract String getName();

    public abstract byte getProviderID();

    public abstract String getCategory();

    public abstract String getSubCategory();

    public abstract String getData();

    public abstract String getDisplayableData();

    public abstract int getDataType();

    public abstract void readFromBuf(ByteBuf var1);

    public abstract void writeToBuf(ByteBuf var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract boolean isEqualType(Info var1);

    public abstract void emptyData();

    public abstract T newInfo();

    public boolean isDataEqualType(Info info) {
        if (info == null) {
            return false;
        }
        return this.getData().equals(info.getData()) && this.getDisplayableData().equals(info.getDisplayableData());
    }

    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, float scale) {
        InfoRenderer.renderStandardInfo(this, Minecraft.func_71410_x().field_71466_p, minX, minY, maxX, maxY, zOffset, scale);
    }

    public boolean isLoadable() {
        return true;
    }
}

