/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.utils.BlockCoords;

public class DataEmitter {
    public String name;
    public BlockCoords coords;

    public DataEmitter(String name, BlockCoords coords) {
        this.name = name;
        this.coords = coords;
    }

    public static DataEmitter readFromNBT(NBTTagCompound tag) {
        if (tag.func_74767_n("b")) {
            return new DataEmitter(tag.func_74779_i("clientName"), BlockCoords.readFromNBT((NBTTagCompound)tag));
        }
        return null;
    }

    public static void writeToNBT(NBTTagCompound tag, DataEmitter info) {
        if (info != null) {
            tag.func_74757_a("b", true);
            tag.func_74778_a("clientName", info.name);
            BlockCoords.writeToNBT((NBTTagCompound)tag, (BlockCoords)info.coords);
        } else {
            tag.func_74757_a("b", false);
        }
    }

    public static DataEmitter readInfo(ByteBuf buf) {
        if (buf.readBoolean()) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            BlockCoords coords = BlockCoords.readFromBuf((ByteBuf)buf);
            return new DataEmitter(name, coords);
        }
        return null;
    }

    public static void writeInfo(ByteBuf buf, DataEmitter info) {
        if (info != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)info.name);
            BlockCoords.writeToBuf((ByteBuf)buf, (BlockCoords)info.coords);
        } else {
            buf.writeBoolean(false);
        }
    }
}

