/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import sonar.core.utils.BlockCoords;
import sonar.logistics.api.DataEmitter;
import sonar.logistics.common.tileentity.TileEntityDataEmitter;

public class DataChannel {
    public String channelName;
    public int channelID;
    public List<BlockCoords> emitters = new ArrayList<BlockCoords>();

    public DataChannel(String channelName, int channelID) {
        this.channelName = channelName;
        this.channelID = channelID;
    }

    public void addEmitter(BlockCoords emitter) {
        if (!this.emitters.contains(emitter)) {
            this.emitters.add(emitter);
        } else {
            this.emitters.remove(emitter);
            this.emitters.add(emitter);
        }
    }

    public void removeEmitter(BlockCoords emitter) {
        int i = 0;
        ArrayList<BlockCoords> removeList = new ArrayList<BlockCoords>();
        for (BlockCoords coords : this.emitters) {
            if (BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)emitter)) {
                removeList.add(coords);
            }
            ++i;
        }
        for (BlockCoords remove : removeList) {
            this.emitters.remove(remove);
        }
    }

    public List<DataEmitter> getEmitters() {
        ArrayList<DataEmitter> emitterList = new ArrayList<DataEmitter>();
        for (BlockCoords coords : this.emitters) {
            TileEntity tile;
            if (coords == null || (tile = coords.getTileEntity()) == null || !(tile instanceof TileEntityDataEmitter)) continue;
            TileEntityDataEmitter dataEmitter = (TileEntityDataEmitter)tile;
            if (tile.func_145831_w() == null || tile.func_145837_r()) continue;
            emitterList.add(new DataEmitter(dataEmitter.clientName.getString(), coords));
        }
        return emitterList;
    }
}

