/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import sonar.logistics.Logistics;

public class LogisticsConfig
extends Logistics {
    public static Property blocksblackList;
    public static Property itemsblackList;
    public static boolean sapphireOre;

    public static void initConfiguration(FMLPreInitializationEvent event) {
        LogisticsConfig.loadMainConfig();
        LogisticsConfig.loadBlocks();
        LogisticsConfig.loadItems();
    }

    public static void loadMainConfig() {
        Configuration config = new Configuration(new File("config/Practical-Logistics/Main-Config.cfg"));
        config.load();
        sapphireOre = config.getBoolean("Generate Ore", "settings", true, "Sapphire Ore");
        config.save();
    }

    public static void loadBlocks() {
        Configuration blocks = new Configuration(new File("config/Practical-Logistics/Blocks-BlackList.cfg"));
        blocks.load();
        String[] blockExamples = new String[]{"ExampleBlock", "ExampleBlock2"};
        blocksblackList = blocks.get("Block Config", "Disabled", blockExamples);
        blocks.save();
    }

    public static void loadItems() {
        Configuration items = new Configuration(new File("config/Practical-Logistics/Items-BlackList.cfg"));
        items.load();
        String[] itemExamples = new String[]{"ExampleItem", "ExampleItem2"};
        itemsblackList = items.get("Item Config", "Disabled", itemExamples);
        items.save();
    }

    private static boolean isBlockEnabled(String block) {
        if (block != null) {
            String[] blacklisted = blocksblackList.getStringList();
            for (int i = 0; i < blacklisted.length; ++i) {
                if (blacklisted[i] == null || !blacklisted[i].equals(block)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isItemEnabled(String item) {
        if (item != null) {
            String[] blacklisted = itemsblackList.getStringList();
            for (int i = 0; i < blacklisted.length; ++i) {
                if (blacklisted[i] == null || !blacklisted[i].equals(item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEnabled(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Item item = stack.func_77973_b();
        if (block != null && item instanceof ItemBlock && GameRegistry.findUniqueIdentifierFor((Block)block) != null) {
            return LogisticsConfig.isBlockEnabled(GameRegistry.findUniqueIdentifierFor((Block)block).name);
        }
        if (item != null && GameRegistry.findUniqueIdentifierFor((Item)item) != null) {
            return LogisticsConfig.isItemEnabled(GameRegistry.findUniqueIdentifierFor((Item)item).name);
        }
        return true;
    }
}

