/*
 * Decompiled with CFR 0.152.
 */
package modwarriors.notenoughkeys.keys;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import modwarriors.notenoughkeys.Helper;
import modwarriors.notenoughkeys.NotEnoughKeys;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;

public class KeyHelper {
    public static final File configDir = new File(Minecraft.func_71410_x().field_71412_D, "config");
    private static final Gson GSON = new Gson();
    private static final JsonParser PARSER = new JsonParser();
    public static HashMap<String, String[]> compatibleMods = new HashMap();
    public static HashMap<String, KeyBinding> keybindings = new HashMap();
    public static HashMap<String, boolean[]> alternates = new HashMap();
    public static ArrayList<String> conflictingKeys = new ArrayList();

    public static void registerMod(String modname, String[] keyDecriptions) {
        compatibleMods.put(modname, keyDecriptions);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keyDecriptions.length; ++i) {
            sb.append(keyDecriptions[i]);
            if (i >= keyDecriptions.length - 1) continue;
            sb.append(", ");
        }
        NotEnoughKeys.logger.info(modname + " has be registered with keys " + sb.toString());
    }

    public static boolean isKeyBindingPressed(KeyBinding binding) {
        return Helper.isSpecialKeyBindingPressed(binding, alternates.get(binding.func_151464_g()));
    }

    public static KeyBinding getKeybind(KeyBinding kb) {
        for (KeyBinding keb : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (!keb.equals(kb)) continue;
            return keb;
        }
        return null;
    }

    public static void pullKeyBindings() {
        for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (keyBinding == null || keybindings.containsKey(keyBinding.func_151464_g())) continue;
            keybindings.put(keyBinding.func_151464_g(), keyBinding);
        }
        KeyHelper.updateConflictCategory();
    }

    public static void loadDefaultKeybindsFromFile() {
        File defaultKeysFile = new File(configDir, "DefaultKeys.json");
        if (!defaultKeysFile.exists()) {
            return;
        }
        boolean forceLoadDefault = false;
        try {
            JsonObject jsonObject = PARSER.parse((Reader)new FileReader(defaultKeysFile)).getAsJsonObject();
            boolean bl = forceLoadDefault = jsonObject.has("forceLoad") && jsonObject.get("forceLoad").getAsBoolean();
            if (!forceLoadDefault) {
                defaultKeysFile.renameTo(new File(configDir, ".DefaultKeys.json"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (forceLoadDefault || !new File(Minecraft.func_71410_x().field_71412_D, "options.txt").exists()) {
            KeyHelper.importFile(defaultKeysFile);
        }
    }

    public static void updateConflictCategory() {
        conflictingKeys.clear();
        conflictingKeys.addAll(KeyHelper.getConflictingKeybinds());
    }

    private static ArrayList<String> getConflictingKeybinds() {
        List<KeyBinding> allTheBinds = Arrays.asList(Minecraft.func_71410_x().field_71474_y.field_74324_K);
        ArrayList<String> allTheConflicts = new ArrayList<String>();
        for (KeyBinding bind1 : allTheBinds) {
            for (KeyBinding bind2 : allTheBinds) {
                boolean[] bind2Alts;
                if (bind1.func_151464_g().equals(bind2.func_151464_g()) || bind1.func_151463_i() != bind2.func_151463_i()) continue;
                boolean[] bind1Alts = alternates.get(bind1.func_151464_g());
                if (bind1Alts == null) {
                    bind1Alts = new boolean[]{false, false, false};
                }
                if ((bind2Alts = alternates.get(bind2.func_151464_g())) == null) {
                    bind2Alts = new boolean[]{false, false, false};
                }
                if (!Arrays.equals(bind1Alts, bind2Alts)) continue;
                if (!allTheConflicts.contains(bind1.func_151464_g())) {
                    allTheConflicts.add(bind1.func_151464_g());
                }
                if (allTheConflicts.contains(bind2.func_151464_g())) continue;
                allTheConflicts.add(bind2.func_151464_g());
            }
        }
        return allTheConflicts;
    }

    public static String getExportFile() {
        JsonObject jsonObject = new JsonObject();
        for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            JsonObject keyBindingObj = new JsonObject();
            keyBindingObj.add("keyCode", (JsonElement)new JsonPrimitive((Number)keyBinding.func_151463_i()));
            boolean[] modifiers = alternates.get(keyBinding.func_151464_g());
            if (modifiers != null) {
                keyBindingObj.add("shift", (JsonElement)new JsonPrimitive(Boolean.valueOf(modifiers[0])));
                keyBindingObj.add("control", (JsonElement)new JsonPrimitive(Boolean.valueOf(modifiers[1])));
                keyBindingObj.add("alt", (JsonElement)new JsonPrimitive(Boolean.valueOf(modifiers[2])));
            }
            jsonObject.add(keyBinding.func_151464_g(), (JsonElement)keyBindingObj);
        }
        return KeyHelper.toReadableString(GSON.toJson((JsonElement)jsonObject));
    }

    public static void importFile(File file) {
        try {
            JsonObject jsonObject = PARSER.parse((Reader)new FileReader(file)).getAsJsonObject();
            boolean shift = false;
            boolean control = false;
            boolean alt = false;
            for (Map.Entry ent : jsonObject.entrySet()) {
                if (!keybindings.containsKey(ent.getKey())) continue;
                KeyBinding key = keybindings.get(ent.getKey());
                JsonObject keyBindingObj = ((JsonElement)ent.getValue()).getAsJsonObject();
                int keyCode = keyBindingObj.get("keyCode").getAsInt();
                if (keyBindingObj.has("shift")) {
                    shift = keyBindingObj.get("shift").getAsBoolean();
                    control = keyBindingObj.get("control").getAsBoolean();
                    alt = keyBindingObj.get("alt").getAsBoolean();
                }
                if (alternates.containsKey(ent.getKey())) {
                    KeyHelper.saveKeyBinding(key, keyCode, new boolean[]{shift, control, alt});
                    continue;
                }
                KeyHelper.saveKeyBinding(key, keyCode, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String toReadableString(String json) {
        String readable = "";
        char[] chars = json.toCharArray();
        boolean isIteratingInString = false;
        int tabs = 0;
        for (char c : chars) {
            if (c == '}' || c == ']') {
                readable = KeyHelper.addLineAndTabs(readable, --tabs);
            }
            readable = readable + c;
            if (c == '{' || c == '[') {
                readable = KeyHelper.addLineAndTabs(readable, ++tabs);
            }
            if (c == ':' && !isIteratingInString) {
                readable = readable + " ";
            }
            if (c == '\"') {
                boolean bl = isIteratingInString = !isIteratingInString;
            }
            if (c != ',' || isIteratingInString) continue;
            readable = KeyHelper.addLineAndTabs(readable, tabs);
        }
        return readable;
    }

    private static String addLineAndTabs(String current, int tabs) {
        current = current + '\n';
        for (int i = 0; i < tabs; ++i) {
            current = current + "   ";
        }
        return current;
    }

    public static void saveKeyBinding(KeyBinding key, int keycode, boolean[] modifiers) {
        Minecraft.func_71410_x().field_71474_y.func_151440_a(key, keycode);
        if (modifiers != null && alternates.containsKey(key.func_151464_g())) {
            alternates.put(key.func_151464_g(), modifiers);
        }
        KeyBinding.func_74508_b();
        KeyHelper.updateConflictCategory();
        NotEnoughKeys.saveConfig();
    }
}

