/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.api.energy.IEnergyContainerItem;
import cofh.core.item.ItemBase;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemCapacitor
extends ItemBase
implements IEnergyContainerItem {
    public static final String[] NAMES = new String[]{"creative", "potato", "basic", "hardened", "reinforced", "resonant"};
    public static boolean[] ENABLE = new boolean[]{true, true, true, true, true, true};
    public static int[] SEND = new int[]{100000, 160, 80, 400, 4000, 16000};
    public static int[] RECEIVE = new int[]{0, 0, 200, 800, 8000, 32000};
    public static int[] CAPACITY = new int[]{100000, 32000, 80000, 400000, 4000000, 20000000};

    public ItemCapacitor() {
        super("thermalexpansion");
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.func_77637_a(ThermalExpansion.tabTools);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        if (ENABLE[0]) {
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, Types.CREATIVE.ordinal()), (int)CAPACITY[Types.CREATIVE.ordinal()]));
        }
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, Types.POTATO.ordinal()), (int)CAPACITY[Types.POTATO.ordinal()]));
        for (int i = 2; i < Types.values().length; ++i) {
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, i), (int)0));
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, i), (int)CAPACITY[i]));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.thermalexpansion.capacitor." + NAMES[ItemHelper.getItemDamage((ItemStack)itemStack)];
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (ItemHelper.getItemDamage((ItemStack)itemStack) == Types.CREATIVE.ordinal()) {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
            list.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + SEND[Types.CREATIVE.ordinal()] + " RF/t");
        } else {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)itemStack.field_77990_d.func_74762_e("Energy")) + " / " + StringHelper.getScaledNumber((long)CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)]) + " RF");
            list.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + SEND[ItemHelper.getItemDamage((ItemStack)itemStack)] + "/" + RECEIVE[ItemHelper.getItemDamage((ItemStack)itemStack)] + " RF/t");
        }
        if (this.isActive(itemStack)) {
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.2"));
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.4"));
            list.add(StringHelper.getDeactivationText((String)"info.thermalexpansion.capacitor.3"));
        } else {
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.0"));
            list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.4"));
            list.add(StringHelper.getActivationText((String)"info.thermalexpansion.capacitor.1"));
        }
        if (ItemHelper.getItemDamage((ItemStack)itemStack) == Types.POTATO.ordinal()) {
            list.add(StringHelper.getFlavorText((String)"info.thermalexpansion.capacitor.potato"));
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl) {
        if (n > 8 || !this.isActive(itemStack) || bl) {
            return;
        }
        InventoryPlayer inventoryPlayer = ((EntityPlayer)entity).field_71071_by;
        int n2 = Math.min(this.getEnergyStored(itemStack), SEND[ItemHelper.getItemDamage((ItemStack)itemStack)]);
        ItemStack itemStack2 = inventoryPlayer.func_70448_g();
        if (EnergyHelper.isEnergyContainerItem((ItemStack)itemStack2)) {
            IEnergyContainerItem iEnergyContainerItem = (IEnergyContainerItem)itemStack2.func_77973_b();
            this.extractEnergy(itemStack, iEnergyContainerItem.receiveEnergy(itemStack2, n2, false), false);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (CoreUtils.isFakePlayer((EntityPlayer)entityPlayer)) {
            return itemStack;
        }
        if (entityPlayer.func_70093_af() && this.setActiveState(itemStack, !this.isActive(itemStack))) {
            if (this.isActive(itemStack)) {
                entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.8f);
            } else {
                entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.5f);
            }
        }
        entityPlayer.func_71038_i();
        return itemStack;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.isActive(itemStack);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack itemStack) {
        return false;
    }

    public boolean isDamaged(ItemStack itemStack) {
        return ItemHelper.getItemDamage((ItemStack)itemStack) != Types.CREATIVE.ordinal();
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        return false;
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)];
        }
        return CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)] - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)];
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        int n2 = ItemHelper.getItemDamage((ItemStack)itemStack);
        if (n2 <= Types.POTATO.ordinal()) {
            return 0;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n3 = itemStack.field_77990_d.func_74762_e("Energy");
        int n4 = Math.min(n, Math.min(CAPACITY[n2] - n3, RECEIVE[n2]));
        if (!bl && itemStack.func_77960_j() != Types.CREATIVE.ordinal()) {
            itemStack.field_77990_d.func_74768_a("Energy", n3 += n4);
        }
        return n4;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(n2, SEND[ItemHelper.getItemDamage((ItemStack)itemStack)]));
        if (!bl && itemStack.func_77960_j() != Types.CREATIVE.ordinal()) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
            if (n2 == 0 && itemStack.func_77960_j() == Types.POTATO.ordinal()) {
                itemStack.func_150996_a(Items.field_151168_bH);
            }
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return CAPACITY[itemStack.func_77960_j()];
    }

    public boolean isActive(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack itemStack, boolean bl) {
        if (this.getEnergyStored(itemStack) > 0) {
            itemStack.field_77990_d.func_74757_a("Active", bl);
            return true;
        }
        itemStack.field_77990_d.func_74757_a("Active", false);
        return false;
    }

    static {
        String string = "Item.Capacitor.";
        String string2 = string + StringHelper.titleCase((String)NAMES[0]);
        ItemCapacitor.ENABLE[0] = ThermalExpansion.config.get(string2, "Enable", ENABLE[0]);
        for (int i = 1; i < Types.values().length; ++i) {
            string2 = string + StringHelper.titleCase((String)NAMES[i]);
            ItemCapacitor.ENABLE[i] = ThermalExpansion.config.get(string2, "Recipe", ENABLE[i]);
        }
        string2 = string + StringHelper.titleCase((String)NAMES[5]);
        ItemCapacitor.CAPACITY[5] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Capacity", CAPACITY[5]), (int)(CAPACITY[5] / 10), (int)1000000000);
        ItemCapacitor.SEND[5] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Send", SEND[5]), (int)(SEND[5] / 10), (int)(SEND[5] * 1000));
        ItemCapacitor.RECEIVE[5] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Receive", RECEIVE[5]), (int)(RECEIVE[5] / 10), (int)(RECEIVE[4] * 1000));
        string2 = string + StringHelper.titleCase((String)NAMES[4]);
        ItemCapacitor.CAPACITY[4] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Capacity", CAPACITY[4]), (int)(CAPACITY[4] / 10), (int)CAPACITY[5]);
        ItemCapacitor.SEND[4] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Send", SEND[4]), (int)(SEND[4] / 10), (int)(SEND[4] * 1000));
        ItemCapacitor.RECEIVE[4] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Receive", RECEIVE[4]), (int)(RECEIVE[4] / 10), (int)(RECEIVE[4] * 1000));
        string2 = string + StringHelper.titleCase((String)NAMES[3]);
        ItemCapacitor.CAPACITY[3] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Capacity", CAPACITY[3]), (int)(CAPACITY[3] / 10), (int)CAPACITY[4]);
        ItemCapacitor.SEND[3] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Send", SEND[3]), (int)(SEND[3] / 10), (int)(SEND[3] * 1000));
        ItemCapacitor.RECEIVE[3] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Receive", RECEIVE[3]), (int)(RECEIVE[3] / 10), (int)(RECEIVE[3] * 1000));
        string2 = string + StringHelper.titleCase((String)NAMES[2]);
        ItemCapacitor.CAPACITY[2] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Capacity", CAPACITY[2]), (int)(CAPACITY[2] / 10), (int)CAPACITY[3]);
        ItemCapacitor.RECEIVE[2] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Receive", RECEIVE[2]), (int)(RECEIVE[2] / 10), (int)(RECEIVE[2] * 1000));
        ItemCapacitor.SEND[2] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Send", SEND[2]), (int)(SEND[2] / 10), (int)(SEND[2] * 1000));
        string2 = string + StringHelper.titleCase((String)NAMES[1]);
        ItemCapacitor.CAPACITY[1] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Capacity", CAPACITY[1]), (int)(CAPACITY[1] / 10), (int)CAPACITY[2]);
        ItemCapacitor.SEND[1] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Send", SEND[1]), (int)(SEND[1] / 10), (int)(SEND[1] * 1000));
        string2 = string + StringHelper.titleCase((String)NAMES[0]);
        ItemCapacitor.SEND[0] = MathHelper.clampI((int)ThermalExpansion.config.get(string2, "Send", SEND[0]), (int)(SEND[0] / 10), (int)(SEND[0] * 1000));
        ItemCapacitor.CAPACITY[0] = SEND[0];
    }

    public static enum Types {
        CREATIVE,
        POTATO,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

