/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiSawmill;
import cofh.thermalexpansion.gui.container.machine.ContainerSawmill;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.util.crafting.SawmillManager;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileSawmill
extends TileMachineBase {
    static final int TYPE = BlockMachine.Types.SAWMILL.ordinal();
    int inputTracker;
    int outputTrackerPrimary;
    int outputTrackerSecondary;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE].numConfig = 6;
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2}, {3}, {1, 2, 3}, {0, 1, 2, 3}};
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE].allowInsertionSide = new boolean[]{false, true, false, false, false, true};
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE].allowExtractionSide = new boolean[]{false, true, true, true, true, true};
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false, false};
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE].allowExtractionSlot = new boolean[]{true, true, true, true, false};
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE].sideTex = new int[]{0, 1, 2, 3, 4, 7};
        TileMachineBase.defaultSideConfig[TileSawmill.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        String string = "Machine.Sawmill";
        int n = MathHelper.clampI((int)ThermalExpansion.config.get(string, "BasePower", 20), (int)10, (int)500);
        ThermalExpansion.config.set(string, "BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileSawmill.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        TileMachineBase.sounds[TileSawmill.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineSawmill");
        GameRegistry.registerTileEntity(TileSawmill.class, (String)"thermalexpansion.Sawmill");
    }

    public TileSawmill() {
        this.inventory = new ItemStack[5];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        SawmillManager.RecipeSawmill recipeSawmill = SawmillManager.getRecipe(this.inventory[0]);
        if (recipeSawmill == null || this.energyStorage.getEnergyStored() < recipeSawmill.getEnergy() * this.energyMod / this.processMod) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipeSawmill.getInput().field_77994_a) {
            return false;
        }
        ItemStack itemStack = recipeSawmill.getPrimaryOutput();
        ItemStack itemStack2 = recipeSawmill.getSecondaryOutput();
        if (!this.augmentSecondaryNull && itemStack2 != null && this.inventory[3] != null) {
            if (!this.inventory[3].func_77969_a(itemStack2)) {
                return false;
            }
            if (this.inventory[3].field_77994_a + itemStack2.field_77994_a > itemStack2.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[1] == null || this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(itemStack) && !this.inventory[2].func_77969_a(itemStack)) {
            return false;
        }
        if (!this.inventory[1].func_77969_a(itemStack)) {
            return this.inventory[2].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
        }
        if (!this.inventory[2].func_77969_a(itemStack)) {
            return this.inventory[1].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
        }
        return this.inventory[1].field_77994_a + this.inventory[2].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d() * 2;
    }

    @Override
    protected boolean hasValidInput() {
        SawmillManager.RecipeSawmill recipeSawmill = SawmillManager.getRecipe(this.inventory[0]);
        return recipeSawmill == null ? false : recipeSawmill.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = SawmillManager.getRecipe(this.inventory[0]).getEnergy();
    }

    @Override
    protected void processFinish() {
        int n;
        SawmillManager.RecipeSawmill recipeSawmill = SawmillManager.getRecipe(this.inventory[0]);
        if (recipeSawmill == null) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
            return;
        }
        ItemStack itemStack = recipeSawmill.getPrimaryOutput();
        ItemStack itemStack2 = recipeSawmill.getSecondaryOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = itemStack;
        } else if (this.inventory[1].func_77969_a(itemStack)) {
            n = this.inventory[1].field_77994_a + itemStack.field_77994_a;
            if (n <= itemStack.func_77976_d()) {
                this.inventory[1].field_77994_a += itemStack.field_77994_a;
            } else {
                int n2 = itemStack.func_77976_d() - this.inventory[1].field_77994_a;
                this.inventory[1].field_77994_a += n2;
                if (this.inventory[2] == null) {
                    this.inventory[2] = itemStack;
                    this.inventory[2].field_77994_a = itemStack.field_77994_a - n2;
                } else {
                    this.inventory[2].field_77994_a += itemStack.field_77994_a - n2;
                }
            }
        } else if (this.inventory[2] == null) {
            this.inventory[2] = itemStack;
        } else {
            this.inventory[2].field_77994_a += itemStack.field_77994_a;
        }
        if (itemStack2 != null && ((n = recipeSawmill.getSecondaryOutputChance()) >= 100 || ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < n)) {
            if (this.inventory[3] == null) {
                this.inventory[3] = itemStack2;
            } else if (this.inventory[3].func_77969_a(itemStack2)) {
                this.inventory[3].field_77994_a += itemStack2.field_77994_a;
            }
            if (ItemHelper.itemsEqualWithMetadata((ItemStack)itemStack2, (ItemStack)TEItems.sawdust) && this.secondaryChance < n && ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < n - this.secondaryChance) {
                this.inventory[3].field_77994_a += itemStack2.field_77994_a;
            }
            if (this.inventory[3].field_77994_a > this.inventory[3].func_77976_d()) {
                this.inventory[3].field_77994_a = this.inventory[3].func_77976_d();
            }
        }
        this.inventory[0].field_77994_a -= recipeSawmill.getInput().field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.augmentAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 1 || !this.extractItem(0, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.inputTracker = n;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int n;
        int n2;
        if (!this.augmentAutoOutput) {
            return;
        }
        if (this.inventory[1] != null || this.inventory[2] != null) {
            for (n2 = this.outputTrackerPrimary + 1; n2 <= this.outputTrackerPrimary + 6; ++n2) {
                n = n2 % 6;
                if (this.sideCache[n] != 2 && this.sideCache[n] != 4) continue;
                if (this.transferItem(1, TileMachineBase.AUTO_TRANSFER[this.level] >> 1, n)) {
                    if (!this.transferItem(2, TileMachineBase.AUTO_TRANSFER[this.level] >> 1, n)) {
                        this.transferItem(1, TileMachineBase.AUTO_TRANSFER[this.level] >> 1, n);
                    }
                    this.outputTrackerPrimary = n;
                    break;
                }
                if (!this.transferItem(2, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
                this.outputTrackerPrimary = n;
                break;
            }
        }
        if (this.inventory[3] == null) {
            return;
        }
        for (n2 = this.outputTrackerSecondary + 1; n2 <= this.outputTrackerSecondary + 6; ++n2) {
            n = n2 % 6;
            if (this.sideCache[n] != 3 && this.sideCache[n] != 4 || !this.transferItem(3, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.outputTrackerSecondary = n;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiSawmill(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerSawmill(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.inputTracker = nBTTagCompound.func_74762_e("TrackIn");
        this.outputTrackerPrimary = nBTTagCompound.func_74762_e("TrackOut1");
        this.outputTrackerSecondary = nBTTagCompound.func_74762_e("TrackOut2");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("TrackIn", this.inputTracker);
        nBTTagCompound.func_74768_a("TrackOut1", this.outputTrackerPrimary);
        nBTTagCompound.func_74768_a("TrackOut2", this.outputTrackerSecondary);
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return n == 0 ? SawmillManager.recipeExists(itemStack) : true;
    }
}

