/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.network.PacketCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.util.CoreUtils;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.gui.client.machine.GuiCrucible;
import cofh.thermalexpansion.gui.container.machine.ContainerCrucible;
import cofh.thermalexpansion.util.crafting.CrucibleManager;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileCrucible
extends TileMachineBase
implements IFluidHandler {
    static final int TYPE = BlockMachine.Types.CRUCIBLE.ordinal();
    int inputTracker;
    int outputTrackerFluid;
    FluidTankAdv tank = new FluidTankAdv(10000);
    FluidStack outputBuffer;
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 0);

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].numConfig = 4;
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].allowInsertionSide = new boolean[]{false, true, false, true};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].allowExtractionSide = new boolean[]{false, true, false, true};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].allowInsertionSlot = new boolean[]{true, false};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].allowExtractionSlot = new boolean[]{true, false};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].sideTex = new int[]{0, 1, 4, 7};
        TileMachineBase.defaultSideConfig[TileCrucible.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        String string = "Machine.Crucible";
        int n = MathHelper.clampI((int)ThermalExpansion.config.get(string, "BasePower", 400), (int)10, (int)500);
        ThermalExpansion.config.set(string, "BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileCrucible.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParams(n / 10, n, Math.max(400000, n * 1000));
        TileMachineBase.sounds[TileCrucible.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineCrucible");
        GameRegistry.registerTileEntity(TileCrucible.class, (String)"thermalexpansion.Crucible");
    }

    public TileCrucible() {
        this.inventory = new ItemStack[2];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        CrucibleManager.RecipeCrucible recipeCrucible = CrucibleManager.getRecipe(this.inventory[0]);
        if (recipeCrucible == null || this.energyStorage.getEnergyStored() < recipeCrucible.getEnergy() * this.energyMod / this.processMod) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipeCrucible.getInput().field_77994_a) {
            return false;
        }
        FluidStack fluidStack = recipeCrucible.getOutput();
        return this.tank.fill(fluidStack, false) == fluidStack.amount;
    }

    @Override
    protected boolean hasValidInput() {
        CrucibleManager.RecipeCrucible recipeCrucible = CrucibleManager.getRecipe(this.inventory[0]);
        return recipeCrucible == null ? false : recipeCrucible.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = CrucibleManager.getRecipe(this.inventory[0]).getEnergy();
        int n = this.renderFluid.getFluidID();
        this.renderFluid = CrucibleManager.getRecipe(this.inventory[0]).getOutput();
        this.renderFluid.amount = 0;
        if (n != this.renderFluid.getFluidID()) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        CrucibleManager.RecipeCrucible recipeCrucible = CrucibleManager.getRecipe(this.inventory[0]);
        if (recipeCrucible == null) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
            return;
        }
        this.tank.fill(recipeCrucible.getOutput(), true);
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.augmentAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 1 || !this.extractItem(0, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.inputTracker = n;
            break;
        }
    }

    protected void transferOutputFluid() {
        if (!this.augmentAutoOutput) {
            return;
        }
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        this.outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 500));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int n;
            int n2 = i % 6;
            if (this.sideCache[n2] != 2 || (n = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)n2, (FluidStack)this.outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(n, true);
            this.outputTrackerFluid = n2;
            break;
        }
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        this.transferOutputFluid();
        super.func_145845_h();
    }

    @Override
    protected void onLevelChange() {
        super.onLevelChange();
        this.tank.setCapacity(10000 * TileMachineBase.FLUID_CAPACITY[this.level]);
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiCrucible(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerCrucible(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.inputTracker = nBTTagCompound.func_74762_e("TrackIn");
        this.outputTrackerFluid = nBTTagCompound.func_74762_e("TrackOut");
        this.tank.readFromNBT(nBTTagCompound);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        } else if (CrucibleManager.getRecipe(this.inventory[0]) != null) {
            this.renderFluid = CrucibleManager.getRecipe(this.inventory[0]).getOutput();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("TrackIn", this.inputTracker);
        nBTTagCompound.func_74768_a("TrackOut", this.outputTrackerFluid);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addFluidStack(this.renderFluid);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        if (this.tank.getFluid() == null) {
            packetCoFHBase.addFluidStack(this.renderFluid);
        } else {
            packetCoFHBase.addFluidStack(this.tank.getFluid());
        }
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase packetCoFHBase = super.getFluidPacket();
        packetCoFHBase.addFluidStack(this.renderFluid);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.tank.setFluid(packetCoFHBase.getFluidStack());
    }

    @Override
    protected void handleFluidPacket(PacketCoFHBase packetCoFHBase) {
        super.handleFluidPacket(packetCoFHBase);
        this.renderFluid = packetCoFHBase.getFluidStack();
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return n == 0 ? CrucibleManager.recipeExists(itemStack) : true;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.renderFluid = packetCoFHBase.getFluidStack();
        } else {
            packetCoFHBase.getFluidStack();
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        if (fluidStack == null || !fluidStack.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(fluidStack.amount, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            if (n == 0) {
                return IconRegistry.getIcon((String)"MachineBottom");
            }
            if (n == 1) {
                return IconRegistry.getIcon((String)"MachineTop");
            }
            return n != this.facing ? IconRegistry.getIcon((String)"MachineSide") : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : IconRegistry.getIcon((String)"MachineFace", (int)this.getType()));
        }
        return n != this.facing ? IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]) : (this.isActive ? IconRegistry.getIcon((String)"MachineActive", (int)this.getType()) : IconRegistry.getIcon((String)"MachineFace", (int)this.getType()));
    }
}

