/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.light;

import cofh.api.tileentity.ITileInfo;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.gui.client.GuiLight;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLight
extends TileTEBase
implements ITileInfo {
    public byte mode;
    public boolean modified;
    public boolean isPowered;
    public byte inputPower;
    public boolean dim;
    public byte style;
    public byte alignment;
    int lightValue;
    public int color = 0xFFFFFF;
    int renderColor = -1431655681;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileLight.class, (String)"thermalexpansion.Light");
    }

    public boolean canUpdate() {
        return false;
    }

    public String getName() {
        return "tile.thermalexpansion.light.name";
    }

    public int getType() {
        return 0;
    }

    public int getLightValue() {
        return this.dim ? 0 : this.getInternalLight();
    }

    public int getInternalLight() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return this.lightValue;
        }
        switch (this.mode) {
            case 0: {
                return this.isPowered ? 15 : 0;
            }
            case 1: {
                return this.isPowered ? 0 : 15;
            }
            case 2: {
                return this.inputPower;
            }
            case 3: {
                return 15 - this.inputPower;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    public void onNeighborBlockChange() {
        boolean bl = this.isPowered;
        byte by = this.inputPower;
        this.isPowered = ((TileEntity)this).field_145850_b.func_72864_z(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        this.inputPower = (byte)((TileEntity)this).field_145850_b.func_94577_B(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        if (bl != this.isPowered || by != this.inputPower) {
            this.func_70296_d();
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        switch (this.style) {
            case 0: {
                this.mode = (byte)(this.mode + 1);
                this.mode = (byte)(this.mode % 6);
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(StringHelper.localize((String)("chat.thermalexpansion.light." + this.mode))));
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (n >> 1 != (this.alignment & 7) >> 1) break;
                this.alignment = (byte)(this.alignment ^ 8);
                break;
            }
        }
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public int getColorMultiplier() {
        return this.renderColor;
    }

    public boolean resetColor() {
        if (!this.modified) {
            return false;
        }
        this.modified = false;
        this.color = 0xFFFFFF;
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setColor(int n) {
        if (n == this.color) {
            return false;
        }
        this.modified = true;
        this.color = n;
        this.setRenderColor();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setRenderColor() {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            return false;
        }
        int n = 10 + this.getInternalLight() / 3;
        int n2 = (this.color >> 16 & 0xFF) * n / 15;
        int n3 = (this.color >> 8 & 0xFF) * n / 15;
        int n4 = (this.color & 0xFF) * n / 15;
        this.renderColor = (n2 << 24) + (n3 << 16) + (n4 << 8) + 255;
        return true;
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.mode = nBTTagCompound.func_74771_c("Mode");
        this.dim = nBTTagCompound.func_74767_n("Dim");
        if (nBTTagCompound.func_74764_b("Color")) {
            this.setColor(nBTTagCompound.func_74762_e("Color"));
        }
        ((TileEntity)this).field_145850_b.func_147451_t(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74774_a("Mode", this.mode);
        nBTTagCompound.func_74757_a("Dim", this.dim);
        if (this.modified) {
            nBTTagCompound.func_74768_a("Color", this.color);
        }
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiLight(inventoryPlayer, this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this, false, false);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.modified);
        if (this.modified) {
            packetCoFHBase.addInt(this.color);
        }
        packetCoFHBase.addByte(this.mode);
        packetCoFHBase.addBool(this.dim);
        packetCoFHBase.addByte(this.style);
        if (this.style != 0) {
            packetCoFHBase.addByte(this.alignment);
        }
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            packetCoFHBase.addByte(this.getInternalLight());
        }
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        this.resetColor();
        return packetCoFHBase;
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.resetColor();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.modified = packetCoFHBase.getBool();
        if (this.modified) {
            this.setColor(packetCoFHBase.getInt());
        }
        this.mode = packetCoFHBase.getByte();
        this.dim = packetCoFHBase.getBool();
        this.style = packetCoFHBase.getByte();
        if (this.style != 0) {
            this.alignment = packetCoFHBase.getByte();
        }
        if (!bl) {
            this.lightValue = packetCoFHBase.getByte();
            this.setRenderColor();
            ((TileEntity)this).field_145850_b.func_147451_t(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.modified = nBTTagCompound.func_74767_n("Modified");
        this.mode = nBTTagCompound.func_74771_c("Mode");
        this.color = nBTTagCompound.func_74762_e("Color");
        this.isPowered = nBTTagCompound.func_74767_n("Powered");
        this.inputPower = nBTTagCompound.func_74771_c("Signal");
        this.dim = nBTTagCompound.func_74767_n("Dim");
        this.style = nBTTagCompound.func_74771_c("Style");
        this.alignment = nBTTagCompound.func_74771_c("Align");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Modified", this.modified);
        nBTTagCompound.func_74774_a("Mode", this.mode);
        nBTTagCompound.func_74768_a("Color", this.color);
        nBTTagCompound.func_74757_a("Powered", this.isPowered);
        nBTTagCompound.func_74774_a("Signal", this.inputPower);
        nBTTagCompound.func_74757_a("Dim", this.dim);
        nBTTagCompound.func_74774_a("Style", this.style);
        nBTTagCompound.func_74774_a("Align", this.alignment);
    }

    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (bl) {
            list.add((IChatComponent)new ChatComponentText("Dim: " + this.dim));
        }
        list.add((IChatComponent)new ChatComponentTranslation("chat.thermalexpansion.light." + this.mode, new Object[0]));
    }
}

