/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.network;

import com.draco18s.artifacts.ArtifactClientEventHandler;
import com.draco18s.artifacts.client.AntibuilderParticle;
import com.draco18s.artifacts.client.RadarParticle;
import com.draco18s.artifacts.entity.TileEntityDisplayPedestal;
import com.draco18s.artifacts.network.SToCMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemRecord;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandlerClient
implements IMessageHandler<SToCMessage, IMessage> {
    public static final int ORE_RADAR = 23;
    public static final int OBSCURITY = 28;
    public static final int CAKE_PARTICLES = 29;
    public static final int PLAY_RECORD = 30;
    public static final int PEDESTAL = 256;
    public static final int ANTI_BUILDER = 4097;

    public IMessage onMessage(SToCMessage packet, MessageContext context) {
        EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
        World world = p.field_70170_p;
        ByteArrayInputStream stream = new ByteArrayInputStream(packet.getData());
        DataInputStream dis = new DataInputStream(stream);
        try {
            int effectID = dis.readInt();
            switch (effectID) {
                case 23: {
                    int x = dis.readInt();
                    int y = dis.readInt();
                    int z = dis.readInt();
                    if ((double)y >= p.field_70163_u) {
                        PacketHandlerClient.drawParticle(p.field_70170_p, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "radar", 0);
                        break;
                    }
                    PacketHandlerClient.drawParticle(p.field_70170_p, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "radar", 0);
                    break;
                }
                case 28: {
                    p.func_70690_d(new PotionEffect(14, 600, 0));
                    ArtifactClientEventHandler.cloaked = true;
                    break;
                }
                case 256: {
                    TileEntity te = world.func_147438_o(dis.readInt(), dis.readInt(), dis.readInt());
                    if (te instanceof TileEntityDisplayPedestal) {
                        TileEntityDisplayPedestal ted = (TileEntityDisplayPedestal)te;
                        int nameLength = dis.readInt();
                        String name = "";
                        for (int s = 0; s < nameLength; ++s) {
                            name = name + dis.readChar();
                        }
                        ted.ownerName = name;
                    }
                    break;
                }
                case 29: {
                    Random rand = new Random();
                    int cakeX = dis.readInt();
                    int cakeY = dis.readInt();
                    int cakeZ = dis.readInt();
                    for (int i = 0; i < 20; ++i) {
                        double pX = (double)cakeX + rand.nextDouble();
                        double pY = (double)cakeY + rand.nextDouble() * 0.5;
                        double pZ = (double)cakeZ + rand.nextDouble();
                        double vX = rand.nextGaussian() * 0.02;
                        double vY = rand.nextGaussian() * 0.02;
                        double vZ = rand.nextGaussian() * 0.02;
                        Minecraft.func_71410_x().field_71441_e.func_72869_a("explode", pX, pY, pZ, vX, vY, vZ);
                    }
                    break;
                }
                case 30: {
                    int recordX = dis.readInt();
                    int recordY = dis.readInt();
                    int recordZ = dis.readInt();
                    boolean play = dis.readBoolean();
                    if (play) {
                        String record = "";
                        int length = dis.readInt();
                        for (int i = 0; i < length; ++i) {
                            record = record + dis.readChar();
                        }
                        if (ItemRecord.func_150926_b((String)("records." + record)) != null) {
                            p.field_70170_p.func_72934_a("records." + record, recordX, recordY, recordZ);
                            break;
                        }
                        System.out.println("The record " + record + "doesn't exist!");
                        p.field_70170_p.func_72934_a(null, recordX, recordY, recordZ);
                        break;
                    }
                    p.field_70170_p.func_72934_a(null, recordX, recordY, recordZ);
                    break;
                }
                case 4097: {
                    double tx = dis.readDouble();
                    double ty = dis.readDouble();
                    double tz = dis.readDouble();
                    int a = dis.readInt();
                    PacketHandlerClient.drawParticle(p.field_70170_p, tx, ty, tz, "reset", a);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Failed to read packet");
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawParticle(World worldObj, double srcX, double srcY, double srcZ, String par1Str, int age) {
        double tx = srcX;
        double ty = srcY;
        double tz = srcZ;
        EntityFX particle = null;
        if (par1Str.equals("radar")) {
            particle = new RadarParticle(worldObj, tx, ty, tz, 3.0f, 20);
        }
        if (par1Str.equals("reset")) {
            particle = new AntibuilderParticle(worldObj, tx, ty, tz, 1.0f, age, 48);
        }
        if (particle != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
    }
}

