/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.factory;

import com.draco18s.artifacts.api.ArtifactsAPI;
import com.draco18s.artifacts.api.IArtifactAPI;
import com.draco18s.artifacts.api.WeightedRandomArtifact;
import com.draco18s.artifacts.api.interfaces.IArtifactComponent;
import com.draco18s.artifacts.components.ComponentAdrenaline;
import com.draco18s.artifacts.components.ComponentAirWalk;
import com.draco18s.artifacts.components.ComponentBaking;
import com.draco18s.artifacts.components.ComponentBreathing;
import com.draco18s.artifacts.components.ComponentCashout;
import com.draco18s.artifacts.components.ComponentDamage;
import com.draco18s.artifacts.components.ComponentExcavation;
import com.draco18s.artifacts.components.ComponentExplodingArrows;
import com.draco18s.artifacts.components.ComponentExplosive;
import com.draco18s.artifacts.components.ComponentFireball;
import com.draco18s.artifacts.components.ComponentFoodie;
import com.draco18s.artifacts.components.ComponentHarvesting;
import com.draco18s.artifacts.components.ComponentHeal;
import com.draco18s.artifacts.components.ComponentHealth;
import com.draco18s.artifacts.components.ComponentJumping;
import com.draco18s.artifacts.components.ComponentKnockbackResist;
import com.draco18s.artifacts.components.ComponentLight;
import com.draco18s.artifacts.components.ComponentLightning;
import com.draco18s.artifacts.components.ComponentMassWeb;
import com.draco18s.artifacts.components.ComponentMedkit;
import com.draco18s.artifacts.components.ComponentMining;
import com.draco18s.artifacts.components.ComponentMusicPlayer;
import com.draco18s.artifacts.components.ComponentNormalDamage;
import com.draco18s.artifacts.components.ComponentNull;
import com.draco18s.artifacts.components.ComponentObscurity;
import com.draco18s.artifacts.components.ComponentOreRadar;
import com.draco18s.artifacts.components.ComponentRepair;
import com.draco18s.artifacts.components.ComponentRepairOther;
import com.draco18s.artifacts.components.ComponentResistance;
import com.draco18s.artifacts.components.ComponentResurrect;
import com.draco18s.artifacts.components.ComponentSpeed;
import com.draco18s.artifacts.components.ComponentVision;
import com.draco18s.artifacts.factory.ErrorNullAttachment;
import com.draco18s.artifacts.factory.FactoryItemIcons;
import com.draco18s.artifacts.item.ItemArtifact;
import com.draco18s.artifacts.item.ItemArtifactArmor;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;

public class FactoryArtifact
implements IArtifactAPI {
    private HashMap effects = new HashMap();
    private Random rand = new Random();
    private int numComponents = 0;
    private int Amulet;
    private int Dagger;
    private int Figurine;
    private int Ring;
    private int Staff;
    private int Sword;
    private int Trinket;
    private int Wand;
    private int Armor;
    private int Boots;
    private int Chestplate;
    private int Helm;
    private int Leggings;
    private int Belt;
    private final IArtifactComponent baseDamage = new ComponentNormalDamage();
    private ArrayList<String> nbtkeys = new ArrayList();

    public FactoryArtifact() {
        Configuration config = new Configuration(new File("./config", "ArtifactEffects.cfg"));
        config.load();
        ComponentNull nullComponent = new ComponentNull();
        if (config.get("Effects", "Healing", true).getBoolean(true)) {
            this.registerComponent(new ComponentHeal());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "ExtraDamage", true).getBoolean(true)) {
            this.registerComponent(new ComponentDamage());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Fireballs", true).getBoolean(true)) {
            this.registerComponent(new ComponentFireball());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Harvesting", true).getBoolean(true)) {
            this.registerComponent(new ComponentHarvesting());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Lightning", true).getBoolean(true)) {
            this.registerComponent(new ComponentLightning());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Mining", true).getBoolean(true)) {
            this.registerComponent(new ComponentMining());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Exploding", true).getBoolean(true)) {
            this.registerComponent(new ComponentExplosive());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Illumination", true).getBoolean(true)) {
            this.registerComponent(new ComponentLight());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Value", true).getBoolean(true)) {
            this.registerComponent(new ComponentCashout());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Resistance", true).getBoolean(true)) {
            this.registerComponent(new ComponentResistance());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "JumpBoost", true).getBoolean(true)) {
            this.registerComponent(new ComponentJumping());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "NightVision", true).getBoolean(true)) {
            this.registerComponent(new ComponentVision());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "WaterBreathing", true).getBoolean(true)) {
            this.registerComponent(new ComponentBreathing());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "FoodSaturation", true).getBoolean(true)) {
            this.registerComponent(new ComponentFoodie());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "MoveSpeed", true).getBoolean(true)) {
            this.registerComponent(new ComponentSpeed());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "MaxHealth", true).getBoolean(true)) {
            this.registerComponent(new ComponentHealth());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "ToolRepair", true).getBoolean(true)) {
            this.registerComponent(new ComponentRepair());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "MassWeb", true).getBoolean(true)) {
            this.registerComponent(new ComponentMassWeb());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "AirWalking", true).getBoolean(true)) {
            this.registerComponent(new ComponentAirWalk());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Excavation", true).getBoolean(true)) {
            this.registerComponent(new ComponentExcavation());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "KnockbackResist", true).getBoolean(true)) {
            this.registerComponent(new ComponentKnockbackResist());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Resurrection", true).getBoolean(true)) {
            this.registerComponent(new ComponentResurrect());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "OreFinder", true).getBoolean(true)) {
            this.registerComponent(new ComponentOreRadar());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "FirstAidKit", true).getBoolean(true)) {
            this.registerComponent(new ComponentMedkit());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "AdrenalinePump", true).getBoolean(true)) {
            this.registerComponent(new ComponentAdrenaline());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "RepairOther", true).getBoolean(true)) {
            this.registerComponent(new ComponentRepairOther());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "ExplodingArrows", true).getBoolean(true)) {
            this.registerComponent(new ComponentExplodingArrows());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Obscurity", true).getBoolean(true)) {
            this.registerComponent(new ComponentObscurity());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "Baking", true).getBoolean(true)) {
            this.registerComponent(new ComponentBaking());
        } else {
            this.registerComponent(nullComponent);
        }
        if (config.get("Effects", "MusicPlayer", true).getBoolean(true)) {
            this.registerComponent(new ComponentMusicPlayer());
        } else {
            this.registerComponent(nullComponent);
        }
        config.save();
    }

    @Override
    public IArtifactComponent getComponent(int componentID) {
        IArtifactComponent eff = (IArtifactComponent)this.effects.get(componentID);
        if (eff == null && componentID <= 0) {
            Thread.dumpStack();
            System.out.print("ERROR: NO EFFECT ID " + componentID + " REGISTERED!");
        }
        return eff;
    }

    @Override
    public ItemStack generateRandomArtifact() {
        ItemStack artifact = new ItemStack(ItemArtifact.instance, 1, 0);
        return this.applyRandomEffects(artifact);
    }

    @Override
    public void registerComponent(IArtifactComponent component) {
        this.effects.put(this.effects.size() + 1, component);
    }

    @Override
    public int getComponentCount() {
        return this.effects.size();
    }

    @Override
    public ItemStack applyRandomEffects(ItemStack artifact) {
        String iconType;
        IArtifactComponent c;
        int numEff;
        artifact.field_77990_d = this.createDefault();
        String nameChunk = "";
        this.Amulet = 1;
        this.Dagger = 1;
        this.Figurine = 1;
        this.Ring = 1;
        this.Staff = 1;
        this.Sword = 1;
        this.Trinket = 1;
        this.Wand = 1;
        this.Armor = 1;
        this.Boots = 1;
        this.Chestplate = 1;
        this.Helm = 1;
        this.Leggings = 1;
        this.Belt = 1;
        if (artifact.func_77973_b() instanceof ItemArtifactArmor) {
            return this.applyRandomArmorEffects(artifact);
        }
        String artiName = "";
        Vector<IArtifactComponent> effectsOnItem = new Vector<IArtifactComponent>();
        boolean count = false;
        int[] a = new int[numEff];
        for (numEff = this.rand.nextInt(5) + 1; numEff > 0; --numEff) {
            int effID;
            while ((c = this.getComponent(effID = this.rand.nextInt(this.effects.size()) + 1)) == null) {
            }
            if (c instanceof ComponentRepair && a.length < 3) {
                int[] b = (int[])a.clone();
                a = new int[++numEff];
                for (int bb = 0; bb < b.length; ++bb) {
                    a[bb] = b[bb];
                }
            }
            if (effectsOnItem.contains(c)) {
                ++numEff;
                continue;
            }
            String trigName = c.getRandomTrigger(this.rand, false);
            if (artifact.field_77990_d.func_74764_b(trigName) || trigName.equals("")) {
                ++numEff;
                continue;
            }
            effectsOnItem.add(c);
            artifact.field_77990_d.func_74768_a(trigName, effID);
            artifact = c.attached(artifact, this.rand, a);
            if (artifact == null) {
                try {
                    throw new ErrorNullAttachment(c.getClass() + " returned a null item from attached(ItemStack, Random, int[]).  It should return the item stack.");
                }
                catch (ErrorNullAttachment e) {
                    e.printStackTrace();
                }
            }
            a[numEff - 1] = effID;
            int flags = c.getTextureBitflags();
            this.Amulet += flags % 2;
            this.Dagger += (flags >>= 1) % 2;
            this.Figurine += (flags >>= 1) % 2;
            this.Ring += (flags >>= 1) % 2;
            this.Staff += (flags >>= 1) % 2;
            this.Sword += (flags >>= 1) % 2;
            this.Trinket += (flags >>= 1) % 2;
            this.Wand += (flags >>= 1) % 2;
            flags >>= 1;
            this.Boots += (flags >>= 1) % 2;
            this.Chestplate += (flags >>= 1) % 2;
            this.Helm += (flags >>= 1) % 2;
            this.Leggings += (flags >>= 1) % 2;
            this.Belt += (flags >>= 1) % 2;
            flags = c.getNegTextureBitflags();
            this.Amulet -= flags % 2;
            this.Dagger -= (flags >>= 1) % 2;
            this.Figurine -= (flags >>= 1) % 2;
            this.Ring -= (flags >>= 1) % 2;
            this.Staff -= (flags >>= 1) % 2;
            this.Sword -= (flags >>= 1) % 2;
            this.Trinket -= (flags >>= 1) % 2;
            this.Wand -= (flags >>= 1) % 2;
            this.Armor -= (flags >>= 1) % 2;
            this.Boots -= (flags >>= 1) % 2;
            this.Chestplate -= (flags >>= 1) % 2;
            this.Helm -= (flags >>= 1) % 2;
            this.Leggings -= (flags >>= 1) % 2;
            this.Belt -= (flags >>= 1) % 2;
            if (this.rand.nextInt(4) != 0 || --numEff <= 0) continue;
            a[numEff - 1] = 0;
        }
        this.Amulet = Math.max(this.Amulet, 0);
        this.Dagger = Math.max(this.Dagger, 0);
        this.Figurine = Math.max(this.Figurine, 0);
        this.Ring = Math.max(this.Ring, 0);
        this.Staff = Math.max(this.Staff, 0);
        this.Sword = Math.max(this.Sword, 0);
        this.Trinket = Math.max(this.Trinket, 0);
        this.Wand = Math.max(this.Wand, 0);
        this.Armor = Math.max(this.Armor * 4, 0);
        this.Boots = Math.max(this.Boots, 0);
        this.Chestplate = Math.max(this.Chestplate, 0);
        this.Helm = Math.max(this.Helm, 0);
        this.Leggings = Math.max(this.Leggings, 0);
        this.Belt = Math.max(this.Belt, 0);
        int t = this.Amulet + this.Dagger + this.Figurine + this.Ring + this.Staff + this.Sword + this.Trinket + this.Wand + this.Belt;
        int r = 0;
        artifact.field_77990_d.func_74768_a("armorType", -1);
        if (t > 0) {
            r = this.rand.nextInt(t);
            if ((r -= this.Amulet) <= 0) {
                iconType = "Amulet";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberAmulets;
            } else if ((r -= this.Dagger) <= 0) {
                iconType = "Dagger";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberDaggers;
                if (!effectsOnItem.contains(2)) {
                    artifact = this.baseDamage.attached(artifact, this.rand, a);
                }
            } else if ((r -= this.Figurine) <= 0) {
                iconType = "Figurine";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberFigurines;
            } else if ((r -= this.Ring) <= 0) {
                iconType = "Ring";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberRings;
            } else if ((r -= this.Staff) <= 0) {
                iconType = "Staff";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberStaffs;
            } else if ((r -= this.Sword) <= 0) {
                iconType = "Sword";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberSwords;
                if (!effectsOnItem.contains(2)) {
                    artifact = this.baseDamage.attached(artifact, this.rand, a);
                }
            } else if ((r -= this.Trinket) <= 0) {
                iconType = "Trinket";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberTrinkets;
            } else if ((r -= this.Wand) <= 0) {
                iconType = "Wand";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberWands;
            } else if ((r -= this.Belt) <= 0) {
                iconType = "Belt";
                t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberBelts;
            } else {
                iconType = "Artifact";
                t = 1;
            }
        } else {
            iconType = "Artifact";
            t = 1;
        }
        int r2 = -1;
        int r3 = -1;
        int r4 = this.rand.nextInt(11);
        String matName = "[Material]";
        switch (r4) {
            case 0: {
                matName = "Wood";
                r4 = 0;
                break;
            }
            case 1: 
            case 8: {
                r4 = 1;
                matName = "Stone";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                r4 = 2;
                matName = "Iron";
                break;
            }
            case 4: {
                r4 = 3;
                matName = "Diamond";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                r4 = 4;
                matName = "Gold";
            }
        }
        artifact.field_77990_d.func_74778_a("iconName", iconType);
        artifact.field_77990_d.func_74778_a("matName", matName);
        if (effectsOnItem.size() > 1) {
            r2 = this.rand.nextInt(effectsOnItem.size());
            c = (IArtifactComponent)effectsOnItem.get(r2);
            nameChunk = c.getPreAdj(this.rand);
            artifact.field_77990_d.func_74778_a("preadj", nameChunk);
            artiName = nameChunk + " ";
            artiName = artiName + matName + " " + iconType;
            while (r2 == (r3 = this.rand.nextInt(effectsOnItem.size()))) {
            }
            c = (IArtifactComponent)effectsOnItem.get(r3);
            nameChunk = c.getPostAdj(this.rand);
            artifact.field_77990_d.func_74778_a("postadj", nameChunk);
            artiName = artiName + " " + nameChunk;
        } else if (this.rand.nextBoolean()) {
            r2 = this.rand.nextInt(effectsOnItem.size());
            c = (IArtifactComponent)effectsOnItem.get(r2);
            nameChunk = c.getPreAdj(this.rand);
            artifact.field_77990_d.func_74778_a("preadj", nameChunk);
            artifact.field_77990_d.func_74778_a("postadj", "");
            artiName = nameChunk + " " + matName + " " + iconType;
        } else {
            r3 = this.rand.nextInt(effectsOnItem.size());
            c = (IArtifactComponent)effectsOnItem.get(r3);
            nameChunk = c.getPostAdj(this.rand);
            artifact.field_77990_d.func_74778_a("preadj", "");
            artifact.field_77990_d.func_74778_a("postadj", nameChunk);
            artiName = matName + " " + iconType + " " + nameChunk;
        }
        r = this.rand.nextInt(t);
        artifact.field_77990_d.func_74778_a("name", artiName);
        artifact.field_77990_d.func_74778_a("icon", iconType + (r + 1));
        int col = Color.HSBtoRGB((float)this.rand.nextInt(360) / 360.0f, 0.8f, 1.0f);
        artifact.field_77990_d.func_74772_a("overlay_color", (long)col);
        artiName = "";
        artifact.field_77990_d.func_74768_a("material", r4);
        artifact.field_77990_d.func_74783_a("allComponents", a);
        if (this.rand.nextInt(8) == 0) {
            artifact = this.enchantArtifact(artifact, effectsOnItem, iconType == "Sword" || iconType == "Dagger");
        }
        return artifact;
    }

    private ItemStack applyRandomArmorEffects(ItemStack artifact) {
        IArtifactComponent c;
        int numEff;
        this.Boots = 1;
        this.Helm = 1;
        this.Chestplate = 1;
        this.Leggings = 1;
        String artiName = "";
        Vector<IArtifactComponent> effectsOnItem = new Vector<IArtifactComponent>();
        boolean count = false;
        int[] a = new int[numEff];
        for (numEff = this.rand.nextInt(3) + 1; numEff > 0; --numEff) {
            int effID;
            while ((c = this.getComponent(effID = this.rand.nextInt(this.effects.size()) + 1)) == null) {
            }
            int flags = c.getNegTextureBitflags();
            if ((flags & 0x100) > 0) {
                ++numEff;
                continue;
            }
            if (effectsOnItem.contains(c)) {
                ++numEff;
                if (this.rand.nextInt(8) != 0 || --numEff <= 0) continue;
                a[numEff - 1] = 0;
                continue;
            }
            String trigName = c.getRandomTrigger(this.rand, true);
            if (artifact.field_77990_d.func_74764_b(trigName) || trigName.equals("")) {
                if (trigName.equals("onArmorTickUpdate") && !artifact.field_77990_d.func_74764_b("onArmorTickUpdate2")) {
                    trigName = "onArmorTickUpdate2";
                } else {
                    ++numEff;
                    if (effectsOnItem.size() <= 0 || this.rand.nextInt(8) != 0 || --numEff <= 0) continue;
                    a[numEff - 1] = 0;
                    continue;
                }
            }
            effectsOnItem.add(c);
            artifact.field_77990_d.func_74768_a(trigName, effID);
            artifact = c.attached(artifact, this.rand, a);
            if (artifact == null) {
                try {
                    throw new ErrorNullAttachment(c.getClass() + " returned a null item from attached(ItemStack, Random, int[]).  It should return the item stack.");
                }
                catch (ErrorNullAttachment e) {
                    e.printStackTrace();
                }
            }
            a[numEff - 1] = effID;
            flags = c.getTextureBitflags();
            this.Boots += (flags >>= 9) % 2;
            this.Chestplate += (flags >>= 1) % 2;
            this.Helm += (flags >>= 1) % 2;
            this.Leggings += (flags >>= 1) % 2;
            flags = c.getNegTextureBitflags();
            this.Armor -= (flags >>= 8) % 2;
            this.Boots -= (flags >>= 1) % 2;
            this.Chestplate -= (flags >>= 1) % 2;
            this.Helm -= (flags >>= 1) % 2;
            this.Leggings -= (flags >>= 1) % 2;
            if (this.rand.nextInt(4) != 0 || --numEff <= 0) continue;
            a[numEff - 1] = 0;
        }
        this.Boots = Math.max(this.Boots, 0);
        this.Chestplate = Math.max(this.Chestplate, 0);
        this.Helm = Math.max(this.Helm, 0);
        this.Leggings = Math.max(this.Leggings, 0);
        int t = this.Boots + this.Chestplate + this.Helm + this.Leggings;
        int r = 0;
        String iconType = "";
        if (t <= 0) {
            this.Boots = 1;
            this.Chestplate = 1;
            this.Helm = 1;
            this.Leggings = 1;
            t = 4;
        }
        r = this.rand.nextInt(t) + 1;
        if ((r -= this.Boots) <= 0) {
            iconType = "Boots";
            t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberBoots;
            artifact.field_77990_d.func_74768_a("armorType", 3);
        } else if ((r -= this.Chestplate) <= 0) {
            iconType = "Chestplate";
            t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberChestplates;
            artifact.field_77990_d.func_74768_a("armorType", 1);
        } else if ((r -= this.Helm) <= 0) {
            iconType = "Helm";
            t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberHelms;
            artifact.field_77990_d.func_74768_a("armorType", 0);
        } else if ((r -= this.Leggings) <= 0) {
            iconType = "Leggings";
            t = ((FactoryItemIcons)ArtifactsAPI.itemicons).numberLeggings;
            artifact.field_77990_d.func_74768_a("armorType", 2);
        } else {
            iconType = "Artifact";
            System.out.println("No prefrred icon possible?");
            System.out.println(this.Boots + this.Chestplate + this.Helm + this.Leggings);
            System.out.println(r);
            t = 1;
        }
        String matName = "[Material]";
        int r4 = -1;
        ItemArtifactArmor ar = (ItemArtifactArmor)artifact.func_77973_b();
        if (ar.func_82812_d().equals((Object)ItemArmor.ArmorMaterial.CLOTH)) {
            matName = "Leather";
            r4 = 0;
        }
        if (ar.func_82812_d().equals((Object)ItemArmor.ArmorMaterial.CHAIN)) {
            matName = "Chain";
            r4 = 1;
        }
        if (ar.func_82812_d().equals((Object)ItemArmor.ArmorMaterial.IRON)) {
            matName = "Iron";
            r4 = 2;
        }
        if (ar.func_82812_d().equals((Object)ItemArmor.ArmorMaterial.GOLD)) {
            matName = "Gold";
            r4 = 4;
        }
        if (ar.func_82812_d().equals((Object)ItemArmor.ArmorMaterial.DIAMOND)) {
            matName = "Diamond";
            r4 = 3;
        }
        String nameChunk = "";
        int r2 = -1;
        int r3 = -1;
        artifact.field_77990_d.func_74778_a("iconName", iconType);
        artifact.field_77990_d.func_74778_a("matName", matName);
        if (effectsOnItem.size() > 1) {
            r2 = this.rand.nextInt(effectsOnItem.size());
            c = (IArtifactComponent)effectsOnItem.get(r2);
            nameChunk = c.getPreAdj(this.rand);
            artifact.field_77990_d.func_74778_a("preadj", nameChunk);
            artiName = nameChunk + " ";
            artiName = artiName + matName + " " + iconType;
            while (r2 == (r3 = this.rand.nextInt(effectsOnItem.size()))) {
            }
            c = (IArtifactComponent)effectsOnItem.get(r3);
            nameChunk = c.getPostAdj(this.rand);
            artifact.field_77990_d.func_74778_a("postadj", nameChunk);
            artiName = artiName + " " + nameChunk;
        } else if (this.rand.nextBoolean()) {
            r2 = this.rand.nextInt(effectsOnItem.size());
            c = (IArtifactComponent)effectsOnItem.get(r2);
            nameChunk = c.getPreAdj(this.rand);
            artifact.field_77990_d.func_74778_a("preadj", nameChunk);
            artifact.field_77990_d.func_74778_a("postadj", "");
            artiName = nameChunk + " " + matName + " " + iconType;
        } else {
            r3 = this.rand.nextInt(effectsOnItem.size());
            c = (IArtifactComponent)effectsOnItem.get(r3);
            nameChunk = c.getPostAdj(this.rand);
            artifact.field_77990_d.func_74778_a("preadj", "");
            artifact.field_77990_d.func_74778_a("postadj", nameChunk);
            artiName = matName + " " + iconType + " " + nameChunk;
        }
        r = this.rand.nextInt(t);
        artifact.field_77990_d.func_74778_a("name", artiName);
        artifact.field_77990_d.func_74778_a("icon", iconType + (r + 1));
        int col = Color.HSBtoRGB((float)this.rand.nextInt(360) / 360.0f, 0.8f, 1.0f);
        artifact.field_77990_d.func_74772_a("overlay_color", (long)col);
        artiName = "";
        artifact.field_77990_d.func_74768_a("material", r4);
        artifact.field_77990_d.func_74783_a("allComponents", a);
        if (this.rand.nextInt(8) == 0) {
            artifact = this.enchantArtifactArmor(artifact, effectsOnItem, iconType);
        }
        ItemArtifactArmor aa = (ItemArtifactArmor)artifact.func_77973_b();
        int nbtType = artifact.field_77990_d.func_74762_e("armorType");
        if (aa.field_77881_a != nbtType) {
            Item newItem = artifact.func_77973_b();
            switch (r4) {
                case 0: {
                    newItem = ItemArtifactArmor.clothArray[nbtType];
                    break;
                }
                case 1: {
                    newItem = ItemArtifactArmor.chainArray[nbtType];
                    break;
                }
                case 2: {
                    newItem = ItemArtifactArmor.ironArray[nbtType];
                    break;
                }
                case 3: {
                    newItem = ItemArtifactArmor.diamondArray[nbtType];
                    break;
                }
                case 4: {
                    newItem = ItemArtifactArmor.goldArray[nbtType];
                }
            }
            NBTTagCompound tag = artifact.field_77990_d;
            artifact = new ItemStack(newItem);
            artifact.field_77990_d = tag;
        }
        return artifact;
    }

    private ItemStack enchantArtifactArmor(ItemStack artifact, Vector effectsOnItem, String iconType) {
        Item item = Items.field_151039_o;
        int level = 6;
        while ((level += 2) < 40 && this.rand.nextInt(8) != 0) {
        }
        switch (artifact.field_77990_d.func_74762_e("material")) {
            case 0: {
                if (iconType.equals("helm")) {
                    item = Items.field_151024_Q;
                    break;
                }
                if (iconType.equals("boots")) {
                    item = Items.field_151021_T;
                    break;
                }
                if (iconType.equals("leggings")) {
                    item = Items.field_151026_S;
                    break;
                }
                item = Items.field_151027_R;
                break;
            }
            case 1: {
                if (iconType.equals("helm")) {
                    item = Items.field_151020_U;
                    break;
                }
                if (iconType.equals("boots")) {
                    item = Items.field_151029_X;
                    break;
                }
                if (iconType.equals("leggings")) {
                    item = Items.field_151022_W;
                    break;
                }
                item = Items.field_151023_V;
                break;
            }
            case 2: {
                if (iconType.equals("helm")) {
                    item = Items.field_151028_Y;
                    break;
                }
                if (iconType.equals("boots")) {
                    item = Items.field_151167_ab;
                    break;
                }
                if (iconType.equals("leggings")) {
                    item = Items.field_151165_aa;
                    break;
                }
                item = Items.field_151030_Z;
                break;
            }
            case 3: {
                if (iconType.equals("helm")) {
                    item = Items.field_151169_ag;
                    break;
                }
                if (iconType.equals("boots")) {
                    item = Items.field_151151_aj;
                    break;
                }
                if (iconType.equals("leggings")) {
                    item = Items.field_151149_ai;
                    break;
                }
                item = Items.field_151171_ah;
                break;
            }
            case 4: {
                item = iconType.equals("helm") ? Items.field_151161_ac : (iconType.equals("boots") ? Items.field_151175_af : (iconType.equals("leggings") ? Items.field_151173_ae : Items.field_151163_ad));
            }
        }
        ItemStack stack = new ItemStack(item);
        stack = EnchantmentHelper.func_77504_a((Random)this.rand, (ItemStack)stack, (int)level);
        if (stack.field_77990_d != null) {
            artifact.field_77990_d.func_74782_a("ench", stack.field_77990_d.func_74781_a("ench").func_74737_b());
            NBTTagList tags = artifact.func_77986_q();
            short firstID = tags.func_150305_b(0).func_74765_d("id");
            String enchName = Enchantment.field_77331_b[firstID].func_77320_a();
            artifact.field_77990_d.func_74778_a("enchName", enchName);
            artifact.field_77990_d.func_74778_a("name", enchName + artifact.field_77990_d.func_74779_i("name"));
        }
        return artifact;
    }

    @Override
    public NBTTagCompound createDefault() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("material", 0);
        nbt.func_74778_a("name", "Blank Artifact");
        nbt.func_74778_a("icon", "Artifact");
        int col = Color.HSBtoRGB((float)this.rand.nextInt(360) / 360.0f, 0.8f, 1.0f);
        nbt.func_74772_a("overlay_color", (long)col);
        nbt.func_74783_a("allComponents", new int[]{0, 0, 0, 0, 0});
        return nbt;
    }

    private ItemStack enchantArtifact(ItemStack artifact, Vector effectsOnItem) {
        return this.enchantArtifact(artifact, effectsOnItem, false);
    }

    private ItemStack enchantArtifact(ItemStack artifact, Vector effectsOnItem, boolean isSword) {
        Item item = Items.field_151039_o;
        int level = 6;
        while ((level += 2) < 40 && this.rand.nextInt(8) != 0) {
        }
        if ((isSword || effectsOnItem.contains(this.getComponent(2))) && this.rand.nextBoolean()) {
            switch (artifact.field_77990_d.func_74762_e("material")) {
                case 0: {
                    item = Items.field_151041_m;
                    break;
                }
                case 1: {
                    item = Items.field_151052_q;
                    break;
                }
                case 2: {
                    item = Items.field_151040_l;
                    break;
                }
                case 3: {
                    item = Items.field_151010_B;
                    break;
                }
                case 4: {
                    item = Items.field_151048_u;
                }
            }
        } else if (effectsOnItem.contains(this.getComponent(4)) || effectsOnItem.contains(this.getComponent(6))) {
            switch (artifact.field_77990_d.func_74762_e("material")) {
                case 0: {
                    item = Items.field_151039_o;
                    break;
                }
                case 1: {
                    item = Items.field_151050_s;
                    break;
                }
                case 2: {
                    item = Items.field_151035_b;
                    break;
                }
                case 3: {
                    item = Items.field_151005_D;
                    break;
                }
                case 4: {
                    item = Items.field_151046_w;
                }
            }
        } else {
            int r2 = (int)Math.min(Math.ceil((double)level / 7.0), 3.0);
            artifact.func_77966_a(Enchantment.field_77347_r, r2);
            artifact.field_77990_d.func_74778_a("name", Enchantment.field_77347_r.func_77320_a());
            return artifact;
        }
        ItemStack stack = new ItemStack(item);
        stack = EnchantmentHelper.func_77504_a((Random)this.rand, (ItemStack)stack, (int)level);
        if (stack.field_77990_d != null) {
            artifact.field_77990_d.func_74782_a("ench", stack.field_77990_d.func_74781_a("ench").func_74737_b());
            NBTTagList tags = artifact.func_77986_q();
            short firstID = tags.func_150305_b(0).func_74765_d("id");
            String enchName = Enchantment.field_77331_b[firstID].func_77320_a();
            artifact.field_77990_d.func_74778_a("enchName", enchName);
            artifact.field_77990_d.func_74778_a("name", enchName + artifact.field_77990_d.func_74779_i("name"));
        }
        return artifact;
    }

    @Override
    public ItemStack applyEffectByID(ItemStack artifact, int id, String trigger) {
        if (artifact.field_77990_d == null) {
            artifact.field_77990_d = this.createDefault();
        }
        int[] a = artifact.field_77990_d.func_74759_k("allComponents");
        Vector<Object> effectsOnItem = new Vector<Object>();
        for (int i = 0; i < 5; ++i) {
            if (a[i] == 0) continue;
            effectsOnItem.add(a[i]);
        }
        int numEff = 0;
        IArtifactComponent c = this.getComponent(id);
        if (!effectsOnItem.contains(c)) {
            if (trigger == null || trigger.equals("")) {
                trigger = c.getRandomTrigger(this.rand, false);
            }
            if (!artifact.field_77990_d.func_74764_b(trigger)) {
                effectsOnItem.add(c);
                if (id == 9) {
                    int bonus = a.length * 5;
                    if (numEff == a.length) {
                        numEff = 1;
                        bonus = 0;
                        artifact.field_77994_a = 10;
                    }
                    artifact.field_77990_d.func_74768_a("cashBonus", bonus);
                }
                if (id == 7 && numEff == a.length && trigger == "onDropped") {
                    numEff = 1;
                    artifact.field_77994_a = 10;
                }
                artifact.field_77990_d.func_74768_a(trigger, id);
                for (int i = 0; i < 5; ++i) {
                    if (a[i] != 0) continue;
                    a[i] = id;
                    i = 99;
                }
                artifact.field_77990_d.func_74783_a("allComponents", a);
            }
        }
        return artifact;
    }

    @Override
    public void setTreasureGeneration(String treasureString, int rarity) {
        ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact(ItemArtifact.instance, 0, 1, 1, rarity));
    }

    @Override
    public void registerUpdateNBTKey(String key) {
        this.nbtkeys.add(key);
    }

    @Override
    public ArrayList<String> getNBTKeys() {
        return (ArrayList)this.nbtkeys.clone();
    }

    @Override
    public void setTreasureGeneration(String treasureString, IArtifactAPI.ArtifactType type, int rarity) {
        switch (type) {
            case TOOL: {
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact(ItemArtifact.instance, 0, 1, 1, rarity));
                break;
            }
            case ARMOR_CLOTH: {
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.hcloth, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.ccloth, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.lcloth, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.bcloth, 0, 1, 1, rarity));
                break;
            }
            case ARMOR_CHAIN: {
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.hchain, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.cchain, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.lchain, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.bchain, 0, 1, 1, rarity));
                break;
            }
            case ARMOR_IRON: {
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.hiron, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.ciron, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.liron, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.biron, 0, 1, 1, rarity));
                break;
            }
            case ARMOR_GOLD: {
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.hgold, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.cgold, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.lgold, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.bgold, 0, 1, 1, rarity));
                break;
            }
            case ARMOR_DIAMOND: {
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.hdiamond, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.cdiamond, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.ldiamond, 0, 1, 1, rarity));
                ChestGenHooks.getInfo((String)treasureString).addItem((WeightedRandomChestContent)new WeightedRandomArtifact((Item)ItemArtifactArmor.bdiamond, 0, 1, 1, rarity));
            }
        }
    }
}

