/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.artifacts.components;

import com.draco18s.artifacts.DragonArtifacts;
import com.draco18s.artifacts.components.BaseComponent;
import com.draco18s.artifacts.components.UtilsForComponents;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ComponentResistance
extends BaseComponent {
    @Override
    public String getRandomTrigger(Random rand, boolean isArmor) {
        if (isArmor) {
            return "onArmorTickUpdate";
        }
        String str = "";
        switch (rand.nextInt(3)) {
            case 0: {
                str = "onItemRightClick";
                break;
            }
            case 1: {
                str = "hitEntity";
                break;
            }
            case 2: {
                str = "onUpdate";
            }
        }
        return str;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        UtilsForComponents.sendPotionPacket(11, 600, 0, (Entity)player);
        UtilsForComponents.sendItemDamagePacket(player, player.field_71071_by.field_70461_c, 1);
        itemStack.field_77990_d.func_74768_a("onItemRightClickDelay", 200);
        return itemStack;
    }

    @Override
    public boolean hitEntity(ItemStack itemStack, EntityLivingBase entityLivingHit, EntityLivingBase entityLivingPlayer) {
        if (!entityLivingPlayer.field_70170_p.field_72995_K) {
            entityLivingPlayer.func_70690_d(new PotionEffect(11, 100, 0));
        }
        return false;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (DragonArtifacts.baublesLoaded && stack.field_77990_d != null && UtilsForComponents.equipableByBaubles(stack.field_77990_d.func_74779_i("iconName")) && DragonArtifacts.baublesMustBeEquipped && slot >= 0) {
            return;
        }
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            EntityLivingBase ent = (EntityLivingBase)entity;
            ent.func_70690_d(new PotionEffect(11, 10, 0));
        }
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, String trigger, boolean advTooltip) {
        if (trigger == "passively.") {
            par3List.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"effect.Damage Resistance"));
        } else {
            int time = 0;
            if (trigger == "when inflicting damage.") {
                time = 5;
            } else if (trigger == "when used.") {
                time = 30;
            }
            par3List.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"effect.Damage Resistance"));
            par3List.add("  " + EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)("tool." + trigger)) + " (" + time + " " + StatCollector.func_74838_a((String)"time.seconds") + ")");
        }
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean advTooltip) {
        par3List.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"effect.Damage Resistance"));
    }

    @Override
    public String getPreAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(3)) {
            case 0: {
                str = "Armored";
                break;
            }
            case 1: {
                str = "Shielding";
                break;
            }
            case 2: {
                str = "Guarding";
            }
        }
        return str;
    }

    @Override
    public String getPostAdj(Random rand) {
        String str = "";
        switch (rand.nextInt(2)) {
            case 0: {
                str = "of Protection";
                break;
            }
            case 1: {
                str = "of Armor";
            }
        }
        return str;
    }

    @Override
    public int getTextureBitflags() {
        return 1373;
    }

    @Override
    public int getNegTextureBitflags() {
        return 34;
    }

    @Override
    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack, boolean worn) {
        if (worn) {
            this.onUpdate(itemStack, world, (Entity)player, 0, true);
        }
    }
}

