/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.api.StorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.registry.IWailaTooltipHandler;
import com.jaquadro.minecraft.storagedrawers.api.render.IRenderLabel;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationModule;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class Thaumcraft
extends IntegrationModule {
    private Item[] aspectItems;

    @Override
    public String getModID() {
        return "Thaumcraft";
    }

    @Override
    public void init() throws Throwable {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.aspectItems = new Item[]{GameRegistry.findItem((String)this.getModID(), (String)"ItemResource"), GameRegistry.findItem((String)this.getModID(), (String)"ItemEssence"), GameRegistry.findItem((String)this.getModID(), (String)"ItemWispEssence"), GameRegistry.findItem((String)this.getModID(), (String)"ItemCrystalEssence"), GameRegistry.findItem((String)this.getModID(), (String)"BlockJarFilledItem"), GameRegistry.findItem((String)this.getModID(), (String)"ItemManaBean")};
        StorageDrawersApi.instance().renderRegistry().registerPreLabelRenderHandler(new LabelRenderHandler());
        StorageDrawersApi.instance().wailaRegistry().registerTooltipHandler(new WailaTooltipHandler());
    }

    @Override
    public void postInit() {
    }

    @SubscribeEvent
    public void onDrawerPopulated(DrawerPopulatedEvent event) {
        IDrawer drawer = event.drawer;
        if (drawer.isEmpty()) {
            drawer.setExtendedData("aspect", null);
            return;
        }
        ItemStack protoStack = drawer.getStoredItemPrototype();
        for (Item item : this.aspectItems) {
            if (item != protoStack.func_77973_b()) continue;
            this.setDrawerAspect(drawer, protoStack);
            return;
        }
    }

    private void setDrawerAspect(IDrawer drawer, ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            return;
        }
        if (tag.func_74764_b("AspectFilter")) {
            this.setDrawerAspectName(drawer, tag.func_74779_i("AspectFilter"));
            return;
        }
        NBTTagList tagAspects = tag.func_150295_c("Aspects", 10);
        if (tagAspects == null || tagAspects.func_74745_c() == 0) {
            return;
        }
        NBTTagCompound tagAspect = tagAspects.func_150305_b(0);
        if (tagAspect == null || !tagAspect.func_74764_b("key")) {
            return;
        }
        this.setDrawerAspectName(drawer, tagAspect.func_74779_i("key"));
    }

    private void setDrawerAspectName(IDrawer drawer, String aspectName) {
        AspectList allAspects = ThaumcraftApiHelper.getAllAspects((int)1);
        for (Aspect a : allAspects.aspects.keySet()) {
            if (!a.getTag().equals(aspectName)) continue;
            drawer.setExtendedData("aspect", a);
            return;
        }
    }

    private class LabelRenderHandler
    implements IRenderLabel {
        private LabelRenderHandler() {
        }

        @Override
        public void render(TileEntity tileEntity, IDrawerGroup drawerGroup, int slot, float brightness, float partialTickTime) {
            IDrawer drawer = drawerGroup.getDrawer(slot);
            if (drawer == null) {
                return;
            }
            Object aspectObj = drawer.getExtendedData("aspect");
            if (!(aspectObj instanceof Aspect)) {
                return;
            }
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            Vec3 blockPos = Vec3.func_72443_a((double)((double)tileEntity.field_145851_c + 0.5), (double)((double)tileEntity.field_145848_d + 0.5), (double)((double)tileEntity.field_145849_e + 0.5));
            double distance = blockPos.func_72438_d(player.func_70666_h(partialTickTime));
            if (distance > 10.0) {
                return;
            }
            Aspect aspect = (Aspect)aspectObj;
            if (!ThaumcraftApiHelper.hasDiscoveredAspect((String)player.getDisplayName(), (Aspect)aspect)) {
                return;
            }
            int x = -4;
            int y = -4;
            int w = 8;
            int h = 8;
            if (drawerGroup.getDrawerCount() == 2) {
                x = -16;
                y = 0;
                w = 16;
                h = 16;
            }
            float alpha = 1.0f;
            if (distance > 3.0) {
                alpha = 1.0f - (float)((distance - 3.0) / 7.0);
            }
            int color = aspect.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)32823);
            GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
            ResourceLocation aspectResource = aspect.getImage();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(aspectResource);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)(y + h), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(x + w), (double)(y + h), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(x + w), (double)y, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glDisable((int)32823);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
        }
    }

    private class WailaTooltipHandler
    implements IWailaTooltipHandler {
        private WailaTooltipHandler() {
        }

        @Override
        public String transformItemName(IDrawer drawer, String defaultName) {
            Object aspectObj = drawer.getExtendedData("aspect");
            if (!(aspectObj instanceof Aspect)) {
                return defaultName;
            }
            Aspect aspect = (Aspect)aspectObj;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (!ThaumcraftApiHelper.hasDiscoveredAspect((String)player.getDisplayName(), (Aspect)aspect)) {
                return defaultName + " (???)";
            }
            return defaultName + " (" + aspect.getName() + ")";
        }
    }
}

