/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.integration.AppliedEnergistics;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationModule;
import com.jaquadro.minecraft.storagedrawers.integration.MineTweaker;
import com.jaquadro.minecraft.storagedrawers.integration.NotEnoughItems;
import com.jaquadro.minecraft.storagedrawers.integration.RefinedRelocation;
import com.jaquadro.minecraft.storagedrawers.integration.Thaumcraft;
import com.jaquadro.minecraft.storagedrawers.integration.ThermalExpansion;
import com.jaquadro.minecraft.storagedrawers.integration.Waila;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;

public class IntegrationRegistry {
    private static IntegrationRegistry instance;
    private List<IntegrationModule> registry = new ArrayList<IntegrationModule>();

    private IntegrationRegistry() {
    }

    public static IntegrationRegistry instance() {
        if (instance == null) {
            instance = new IntegrationRegistry();
        }
        return instance;
    }

    public void add(IntegrationModule module) {
        if (module.versionCheck()) {
            this.registry.add(module);
        }
    }

    public void init() {
        for (int i = 0; i < this.registry.size(); ++i) {
            IntegrationModule module = this.registry.get(i);
            if (module.getModID() != null && !Loader.isModLoaded((String)module.getModID())) {
                this.registry.remove(i--);
                continue;
            }
            try {
                module.init();
                continue;
            }
            catch (Throwable t) {
                this.registry.remove(i--);
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("Could not load integration module: " + module.getClass().getName()), (Object[])new Object[0]);
            }
        }
    }

    public void postInit() {
        for (IntegrationModule module : this.registry) {
            module.postInit();
        }
    }

    public boolean isModLoaded(String mod_id) {
        for (IntegrationModule module : this.registry) {
            if (!module.getModID().equals(mod_id)) continue;
            return true;
        }
        return false;
    }

    static {
        IntegrationRegistry reg = IntegrationRegistry.instance();
        if (Loader.isModLoaded((String)"appliedenergistics2") && StorageDrawers.config.cache.enableAE2Integration) {
            reg.add(new AppliedEnergistics());
        }
        if (Loader.isModLoaded((String)"Waila") && StorageDrawers.config.cache.enableWailaIntegration) {
            reg.add(new Waila());
        }
        if (Loader.isModLoaded((String)"Thaumcraft") && StorageDrawers.config.cache.enableThaumcraftIntegration) {
            reg.add(new Thaumcraft());
        }
        if (Loader.isModLoaded((String)"MineTweaker3") && StorageDrawers.config.cache.enableMineTweakerIntegration) {
            reg.add(new MineTweaker());
        }
        if (Loader.isModLoaded((String)"RefinedRelocation") && StorageDrawers.config.cache.enableRefinedRelocationIntegration) {
            reg.add(new RefinedRelocation());
        }
        if (Loader.isModLoaded((String)"NotEnoughItems")) {
            reg.add(new NotEnoughItems());
        }
        if (Loader.isModLoaded((String)"ThermalExpansion") && StorageDrawers.config.cache.enableThermalExpansionIntegration) {
            reg.add(new ThermalExpansion());
        }
    }
}

